/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.config.AbstractProtocolConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class ConfigLookupFunction<T extends AbstractProtocolConfiguration>
implements Function<ProfileRequestContext, T> {
    @Nonnull
    private final Class<T> configClass;

    public ConfigLookupFunction(@Nonnull Class<T> clazz) {
        this.configClass = (Class)Constraint.isNotNull(clazz, (String)"Configuration class cannot be null");
    }

    @Override
    @Nullable
    public T apply(@Nullable ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpContext;
        if (profileRequestContext != null && (rpContext = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class)) != null && this.configClass.isInstance(rpContext.getProfileConfig())) {
            return (T)((Object)((AbstractProtocolConfiguration)((Object)this.configClass.cast(rpContext.getProfileConfig()))));
        }
        return null;
    }
}

