/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import java.util.Comparator;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.AbstractProtocolConfiguration;
import net.shibboleth.idp.cas.service.DefaultServiceComparator;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;

public class ValidateConfiguration
extends AbstractProtocolConfiguration {
    public static final String PROFILE_ID = "https://www.apereo.org/cas/protocol/serviceValidate";
    public static final String DEFAULT_TICKET_PREFIX = "PGT";
    public static final int DEFAULT_TICKET_LENGTH = 50;
    @Nonnull
    private IdentifierGenerationStrategy pgtIOUGenerator = new TicketIdentifierGenerationStrategy("PGTIOU", 50);
    @Nonnull
    private Comparator<String> serviceComparator = new DefaultServiceComparator();

    public ValidateConfiguration() {
        super(PROFILE_ID);
    }

    @Nonnull
    public IdentifierGenerationStrategy getPGTIOUGenerator() {
        return this.pgtIOUGenerator;
    }

    public void setPGTIOUGenerator(@Nonnull IdentifierGenerationStrategy generator) {
        this.pgtIOUGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"PGTIOU generator cannot be null");
    }

    @Nonnull
    public Comparator<String> getServiceComparator() {
        return this.serviceComparator;
    }

    public void setServiceComparator(@Nonnull Comparator<String> serviceComparator) {
        this.serviceComparator = serviceComparator;
    }

    @Override
    @Nonnull
    protected String getDefaultTicketPrefix() {
        return DEFAULT_TICKET_PREFIX;
    }

    @Override
    @Nonnull
    protected int getDefaultTicketLength() {
        return 50;
    }
}

