/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractCASProtocolAction<RequestType, ResponseType>
extends AbstractProfileAction {
    @Nonnull
    protected RequestType getCASRequest(ProfileRequestContext prc) {
        Object request = this.getProtocolContext(prc).getRequest();
        if (request == null) {
            throw new IllegalStateException("CAS protocol request not found");
        }
        return (RequestType)request;
    }

    protected void setCASRequest(ProfileRequestContext prc, @Nonnull RequestType request) {
        this.getProtocolContext(prc).setRequest(Constraint.isNotNull(request, (String)"CAS request cannot be null"));
    }

    @Nonnull
    protected ResponseType getCASResponse(ProfileRequestContext prc) {
        Object response = this.getProtocolContext(prc).getResponse();
        if (response == null) {
            throw new IllegalStateException("CAS protocol response not found");
        }
        return (ResponseType)response;
    }

    protected void setCASResponse(ProfileRequestContext prc, @Nonnull ResponseType response) {
        this.getProtocolContext(prc).setResponse(Constraint.isNotNull(response, (String)"CAS response cannot be null"));
    }

    @Nonnull
    protected Ticket getCASTicket(ProfileRequestContext prc) {
        TicketContext context = (TicketContext)this.getProtocolContext(prc).getSubcontext(TicketContext.class);
        if (context == null || context.getTicket() == null) {
            throw new IllegalStateException("CAS protocol ticket not found");
        }
        return context.getTicket();
    }

    protected void setCASTicket(ProfileRequestContext prc, @Nonnull Ticket ticket) {
        this.getProtocolContext(prc).addSubcontext((BaseContext)new TicketContext((Ticket)Constraint.isNotNull((Object)ticket, (String)"CAS ticket cannot be null")));
    }

    @Nonnull
    protected Service getCASService(ProfileRequestContext prc) {
        ServiceContext context = (ServiceContext)this.getProtocolContext(prc).getSubcontext(ServiceContext.class);
        if (context == null || context.getService() == null) {
            throw new IllegalStateException("CAS protocol service not found");
        }
        return context.getService();
    }

    protected void setCASService(ProfileRequestContext prc, @Nonnull Service service) {
        this.getProtocolContext(prc).addSubcontext((BaseContext)new ServiceContext((Service)Constraint.isNotNull((Object)service, (String)"CAS service cannot be null")));
    }

    @Nonnull
    protected IdPSession getIdPSession(ProfileRequestContext prc) {
        SessionContext sessionContext = (SessionContext)prc.getSubcontext(SessionContext.class);
        if (sessionContext == null || sessionContext.getIdPSession() == null) {
            throw new IllegalStateException("Cannot locate IdP session");
        }
        return sessionContext.getIdPSession();
    }

    protected ProtocolContext<RequestType, ResponseType> getProtocolContext(ProfileRequestContext prc) {
        ProtocolContext casCtx = (ProtocolContext)prc.getSubcontext(ProtocolContext.class, false);
        if (casCtx != null) {
            return casCtx;
        }
        casCtx = new ProtocolContext();
        prc.addSubcontext((BaseContext)casCtx);
        return casCtx;
    }
}

