/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.cas.flow.AbstractOutgoingSamlMessageAction;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.joda.time.DateTime;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSStringBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AttributeValue;
import org.opensaml.saml.saml1.core.Audience;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.Status;
import org.opensaml.saml.saml1.core.StatusCode;
import org.opensaml.saml.saml1.core.Subject;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class BuildSamlValidationSuccessMessageAction
extends AbstractOutgoingSamlMessageAction {
    private static final String NAMESPACE = "http://www.ja-sig.org/products/cas/";
    private final Logger log = LoggerFactory.getLogger(BuildSamlValidationSuccessMessageAction.class);
    private final XSStringBuilder attrValueBuilder = new XSStringBuilder();
    @Nonnull
    private final IdentifierGenerationStrategy identifierGenerationStrategy;
    @Nonnull
    private final String entityID;

    public BuildSamlValidationSuccessMessageAction(IdentifierGenerationStrategy strategy, String entityID) {
        Constraint.isNotNull((Object)strategy, (String)"IdentifierGenerationStrategy cannot be null");
        Constraint.isNotNull((Object)strategy, (String)"EntityID cannot be null");
        this.identifierGenerationStrategy = strategy;
        this.entityID = entityID;
    }

    @Override
    @Nonnull
    protected Response buildSamlResponse(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext<SAMLObject, SAMLObject> profileRequestContext) {
        DateTime now = DateTime.now();
        TicketValidationRequest request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
        TicketValidationResponse ticketResponse = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        IdPSession session = this.getIdPSession(profileRequestContext);
        Response response = BuildSamlValidationSuccessMessageAction.newSAMLObject(Response.class, Response.DEFAULT_ELEMENT_NAME);
        Status status = BuildSamlValidationSuccessMessageAction.newSAMLObject(Status.class, Status.DEFAULT_ELEMENT_NAME);
        StatusCode code = BuildSamlValidationSuccessMessageAction.newSAMLObject(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        code.setValue(StatusCode.SUCCESS);
        status.setStatusCode(code);
        response.setStatus(status);
        Assertion assertion = BuildSamlValidationSuccessMessageAction.newSAMLObject(Assertion.class, Assertion.DEFAULT_ELEMENT_NAME);
        assertion.setID(this.identifierGenerationStrategy.generateIdentifier());
        assertion.setIssueInstant(now);
        assertion.setVersion(SAMLVersion.VERSION_11);
        assertion.setIssuer(this.entityID);
        Conditions conditions = BuildSamlValidationSuccessMessageAction.newSAMLObject(Conditions.class, Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(now);
        conditions.setNotOnOrAfter(now.plusSeconds(60));
        AudienceRestrictionCondition audienceRestriction = BuildSamlValidationSuccessMessageAction.newSAMLObject(AudienceRestrictionCondition.class, AudienceRestrictionCondition.DEFAULT_ELEMENT_NAME);
        Audience audience = BuildSamlValidationSuccessMessageAction.newSAMLObject(Audience.class, Audience.DEFAULT_ELEMENT_NAME);
        audience.setUri(request.getService());
        audienceRestriction.getAudiences().add(audience);
        conditions.getAudienceRestrictionConditions().add(audienceRestriction);
        assertion.setConditions(conditions);
        for (AuthenticationResult result : session.getAuthenticationResults()) {
            assertion.getAuthenticationStatements().add(this.newAuthenticationStatement(now, result.getAuthenticationFlowId(), session.getPrincipalName()));
        }
        AttributeStatement attrStatement = BuildSamlValidationSuccessMessageAction.newSAMLObject(AttributeStatement.class, AttributeStatement.DEFAULT_ELEMENT_NAME);
        attrStatement.setSubject(this.newSubject(session.getPrincipalName()));
        for (String attrName : ticketResponse.getAttributes().keySet()) {
            Attribute attribute = BuildSamlValidationSuccessMessageAction.newSAMLObject(Attribute.class, Attribute.DEFAULT_ELEMENT_NAME);
            attribute.setAttributeName(attrName);
            attribute.setAttributeNamespace(NAMESPACE);
            for (String value : (List)ticketResponse.getAttributes().get(attrName)) {
                attribute.getAttributeValues().add(this.newAttributeValue(value));
            }
            attrStatement.getAttributes().add(attribute);
        }
        assertion.getAttributeStatements().add(attrStatement);
        response.getAssertions().add(assertion);
        return response;
    }

    private Subject newSubject(String identifier) {
        SubjectConfirmation confirmation = BuildSamlValidationSuccessMessageAction.newSAMLObject(SubjectConfirmation.class, SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        ConfirmationMethod method = BuildSamlValidationSuccessMessageAction.newSAMLObject(ConfirmationMethod.class, ConfirmationMethod.DEFAULT_ELEMENT_NAME);
        method.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:artifact");
        confirmation.getConfirmationMethods().add(method);
        NameIdentifier nameIdentifier = BuildSamlValidationSuccessMessageAction.newSAMLObject(NameIdentifier.class, NameIdentifier.DEFAULT_ELEMENT_NAME);
        nameIdentifier.setValue(identifier);
        Subject subject = BuildSamlValidationSuccessMessageAction.newSAMLObject(Subject.class, Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameIdentifier(nameIdentifier);
        subject.setSubjectConfirmation(confirmation);
        return subject;
    }

    private AuthenticationStatement newAuthenticationStatement(DateTime authnInstant, String authnMethod, String principal) {
        AuthenticationStatement authnStatement = BuildSamlValidationSuccessMessageAction.newSAMLObject(AuthenticationStatement.class, AuthenticationStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthenticationInstant(authnInstant);
        authnStatement.setAuthenticationMethod(authnMethod);
        authnStatement.setSubject(this.newSubject(principal));
        return authnStatement;
    }

    private XSString newAttributeValue(String value) {
        XSString stringValue = (XSString)this.attrValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        stringValue.setValue(value);
        return stringValue;
    }
}

