/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.cas.flow.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.Events;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ExtractAttributesAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private final Logger log = LoggerFactory.getLogger(ExtractAttributesAction.class);
    private Function<ProfileRequestContext, AttributeContext> attributeContextFunction = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        AttributeContext ac = (AttributeContext)this.attributeContextFunction.apply((Object)profileRequestContext);
        if (ac == null) {
            this.log.info("AttributeContext not found in profile request context.");
            return ProtocolError.IllegalState.event((Object)this);
        }
        SubjectContext sc = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, false);
        if (sc == null) {
            this.log.info("SubjectContext not found in profile request context.");
            return ProtocolError.IllegalState.event((Object)this);
        }
        TicketValidationResponse response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        response.setUserName(sc.getPrincipalName());
        for (IdPAttribute attribute : ac.getIdPAttributes().values()) {
            this.log.debug("Processing {}", (Object)attribute);
            for (IdPAttributeValue value : attribute.getValues()) {
                response.addAttribute(attribute.getId(), value.getValue().toString());
            }
        }
        return Events.Proceed.event((Object)this);
    }
}

