/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.Events;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.session.CASSPSession;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class UpdateIdPSessionWithSPSessionAction
extends AbstractCASProtocolAction {
    private final Logger log = LoggerFactory.getLogger(UpdateIdPSessionWithSPSessionAction.class);
    @Duration
    @Positive
    private final long sessionLifetime;

    public UpdateIdPSessionWithSPSessionAction(@Duration @Positive long lifetime) {
        this.sessionLifetime = Constraint.isGreaterThan((long)0L, (long)lifetime, (String)"Lifetime must be greater than 0");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        Ticket ticket = this.getCASTicket(profileRequestContext);
        IdPSession session = this.getIdPSession(profileRequestContext);
        long now = System.currentTimeMillis();
        CASSPSession sps = new CASSPSession(ticket.getService(), now, now + this.sessionLifetime, ticket.getId());
        this.log.debug("Created SP session {}", (Object)sps);
        try {
            session.addSPSession((SPSession)sps);
        }
        catch (SessionException e) {
            this.log.warn("Failed updating IdP session with CAS SP session: {}", (Object)e.getMessage());
            return ProtocolError.IllegalState.event((Object)this);
        }
        return Events.Success.event((Object)this);
    }
}

