/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.Events;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidateTicketAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private final Logger log = LoggerFactory.getLogger(ValidateTicketAction.class);
    private final ConfigLookupFunction<ValidateConfiguration> configLookupFunction = new ConfigLookupFunction<ValidateConfiguration>(ValidateConfiguration.class);
    @Nonnull
    private final TicketService ticketService;

    public ValidateTicketAction(@Nonnull TicketService ticketService) {
        this.ticketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ServiceTicket ticket;
        ValidateConfiguration config = this.configLookupFunction.apply(profileRequestContext);
        if (config == null) {
            this.log.info("Ticket validation configuration undefined");
            return ProtocolError.IllegalState.event((Object)this);
        }
        TicketValidationRequest request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
        try {
            String ticketId = request.getTicket();
            this.log.debug("Attempting to validate {}", (Object)ticketId);
            if (ticketId.startsWith("ST")) {
                ticket = this.ticketService.removeServiceTicket(request.getTicket());
            } else if (ticketId.startsWith("PT")) {
                ticket = this.ticketService.removeProxyTicket(ticketId);
            } else {
                return ProtocolError.InvalidTicketFormat.event((Object)this);
            }
            if (ticket != null) {
                this.log.debug("Found and removed {}/{} from ticket store", (Object)ticket, (Object)ticket.getSessionId());
            }
        }
        catch (RuntimeException e) {
            this.log.debug("CAS ticket retrieval failed with error: {}", (Throwable)e);
            return ProtocolError.TicketRetrievalError.event((Object)this);
        }
        if (ticket == null || ticket.getExpirationInstant().isBeforeNow()) {
            return ProtocolError.TicketExpired.event((Object)this);
        }
        if (config.getServiceComparator().compare(ticket.getService(), request.getService()) != 0) {
            this.log.debug("Service issued for {} does not match {}", (Object)ticket.getService(), (Object)request.getService());
            return ProtocolError.ServiceMismatch.event((Object)this);
        }
        this.log.info("Successfully validated {} for {}", (Object)request.getTicket(), (Object)request.getService());
        this.setCASResponse(profileRequestContext, new TicketValidationResponse());
        this.setCASTicket(profileRequestContext, (Ticket)ticket);
        if (ticket instanceof ProxyTicket) {
            return Events.ProxyTicketValidated.event((Object)this);
        }
        return Events.ServiceTicketValidated.event((Object)this);
    }
}

