/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceDefinition;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternServiceRegistry
implements ServiceRegistry {
    private final Logger log = LoggerFactory.getLogger(PatternServiceRegistry.class);
    @Nonnull
    @NonnullElements
    private List<ServiceDefinition> definitions = Collections.emptyList();

    public void setDefinitions(@Nonnull @NonnullElements List<ServiceDefinition> definitions) {
        this.definitions = (List)Constraint.isNotNull(definitions, (String)"Service definition list cannot be null");
    }

    @Nullable
    public Service lookup(@Nonnull String serviceURL) {
        Constraint.isNotNull((Object)serviceURL, (String)"Service URL cannot be null");
        for (ServiceDefinition def : this.definitions) {
            this.log.debug("Evaluating whether {} matches {}", (Object)serviceURL, (Object)def);
            if (!def.matches(serviceURL)) continue;
            this.log.debug("Found match");
            return new Service(serviceURL, def.getGroup(), def.isAuthorizedToProxy());
        }
        return null;
    }
}

