/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.cryptacular.generator.RandomIdGenerator;

public class TicketIdentifierGenerationStrategy
implements IdentifierGenerationStrategy {
    @Nonnull
    @NotEmpty
    private String prefix;
    @Nullable
    private String suffix;
    @Positive
    private int randomLength;

    public TicketIdentifierGenerationStrategy(@Nonnull @NotEmpty String prefix, @Positive int randomLength) {
        this.randomLength = (int)Constraint.isGreaterThan((long)0L, (long)randomLength, (String)"Random length must be positive");
        this.prefix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)prefix), (String)"Prefix cannot be null or empty");
        if (!TicketIdentifierGenerationStrategy.isUrlSafe(this.prefix)) {
            throw new IllegalArgumentException("Unsupported prefix " + this.prefix);
        }
    }

    public void setSuffix(@Nullable String suffix) {
        String s = StringSupport.trimOrNull((String)suffix);
        if (s != null) {
            if (!TicketIdentifierGenerationStrategy.isUrlSafe(s)) {
                throw new IllegalArgumentException("Unsupported suffix " + s);
            }
            this.suffix = s;
        }
    }

    @Nonnull
    public String generateIdentifier() {
        StringBuilder builder = new StringBuilder(this.randomLength * 2);
        builder.append(this.prefix).append('-');
        builder.append(System.currentTimeMillis()).append('-');
        builder.append(new RandomIdGenerator(this.randomLength).generate());
        if (this.suffix != null) {
            builder.append('-').append(this.suffix);
        }
        return builder.toString();
    }

    @Nonnull
    public String generateIdentifier(boolean xmlSafe) {
        return this.generateIdentifier();
    }

    private static boolean isUrlSafe(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.US_ASCII.name()).equals(s);
        }
        catch (Exception e) {
            return false;
        }
    }
}

