/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.audit.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.protocol.AbstractProtocolResponse;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class StatusDetailLookupFunction
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, ProtocolContext> protocolContextFunction;

    public StatusDetailLookupFunction() {
        this((Function<ProfileRequestContext, ProtocolContext>)new ChildContextLookup(ProtocolContext.class));
    }

    public StatusDetailLookupFunction(@Nonnull Function<ProfileRequestContext, ProtocolContext> protocolLookup) {
        this.protocolContextFunction = (Function)Constraint.isNotNull(protocolLookup, (String)"ProtocolContext lookup cannot be null");
    }

    @Nullable
    public String apply(@Nonnull ProfileRequestContext input) {
        ProtocolContext protocolContext = (ProtocolContext)this.protocolContextFunction.apply((Object)input);
        if (protocolContext == null || protocolContext.getRequest() == null) {
            return null;
        }
        Object response = protocolContext.getResponse();
        if (response instanceof AbstractProtocolResponse) {
            return ((AbstractProtocolResponse)response).getErrorDetail();
        }
        return null;
    }
}

