/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.cas.config.impl.AbstractProtocolConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class LoginConfiguration
extends AbstractProtocolConfiguration
implements AuthenticationProfileConfiguration {
    public static final String PROFILE_ID = "https://www.apereo.org/cas/protocol/login";
    public static final String DEFAULT_TICKET_PREFIX = "ST";
    public static final int DEFAULT_TICKET_LENGTH = 25;
    @Nullable
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private Set<String> authenticationFlows;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> postAuthenticationFlows;
    @Nullable
    private Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> defaultAuthenticationContextsLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<AuthnContextClassRefPrincipal> defaultAuthenticationContexts;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> nameIDFormatPrecedenceLookupStrategy;
    @Nonnull
    @NonnullElements
    private List<String> nameIDFormatPrecedence;

    public LoginConfiguration() {
        super(PROFILE_ID);
        this.setTicketValidityPeriod(15000L);
        this.authenticationFlows = Collections.emptySet();
        this.postAuthenticationFlows = Collections.emptyList();
        this.defaultAuthenticationContexts = Collections.emptyList();
        this.nameIDFormatPrecedence = Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.defaultAuthenticationContextsLookupStrategy, this.defaultAuthenticationContexts)));
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthnContextClassRefPrincipal> contexts) {
        this.defaultAuthenticationContexts = contexts != null ? new ArrayList<AuthnContextClassRefPrincipal>(Collections2.filter(contexts, (Predicate)Predicates.notNull())) : Collections.emptyList();
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows() {
        return ImmutableSet.copyOf((Collection)((Collection)this.getIndirectProperty(this.authenticationFlowsLookupStrategy, this.authenticationFlows)));
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlows = flows != null ? new HashSet<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptySet();
    }

    public void setAuthenticationFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.postAuthenticationFlowsLookupStrategy, this.postAuthenticationFlows)));
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlows = flows != null ? new ArrayList<String>(StringSupport.normalizeStringCollection(flows)) : Collections.emptyList();
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = strategy;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.nameIDFormatPrecedenceLookupStrategy, this.nameIDFormatPrecedence)));
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements Collection<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = new ArrayList<String>(StringSupport.normalizeStringCollection(formats));
    }

    public void setNameIDFormatPrecedenceLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.nameIDFormatPrecedenceLookupStrategy = strategy;
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getDefaultTicketPrefix() {
        return DEFAULT_TICKET_PREFIX;
    }

    @Override
    protected int getDefaultTicketLength() {
        return 25;
    }
}

