/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config.impl;

import com.google.common.base.Function;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.config.impl.AbstractProtocolConfiguration;
import net.shibboleth.idp.cas.service.impl.DefaultServiceComparator;
import net.shibboleth.idp.cas.ticket.impl.TicketIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;

public class ValidateConfiguration
extends AbstractProtocolConfiguration {
    public static final String PROFILE_ID = "https://www.apereo.org/cas/protocol/serviceValidate";
    public static final String DEFAULT_TICKET_PREFIX = "PGT";
    public static final int DEFAULT_TICKET_LENGTH = 50;
    @Nullable
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> pgtIOUGeneratorLookupStrategy;
    @Nullable
    private IdentifierGenerationStrategy pgtIOUGenerator = new TicketIdentifierGenerationStrategy("PGTIOU", 50);
    @Nullable
    private Function<ProfileRequestContext, Comparator<String>> serviceComparatorLookupStrategy;
    @Nonnull
    private Comparator<String> serviceComparator = new DefaultServiceComparator();
    @Nullable
    private Function<ProfileRequestContext, String> userAttributeLookupStrategy;
    @Nullable
    private String userAttribute;

    public ValidateConfiguration() {
        super(PROFILE_ID);
    }

    @Nonnull
    public IdentifierGenerationStrategy getPGTIOUGenerator() {
        return (IdentifierGenerationStrategy)Constraint.isNotNull((Object)this.getIndirectProperty(this.pgtIOUGeneratorLookupStrategy, this.pgtIOUGenerator), (String)"PGTIOU generator cannot be null");
    }

    public void setPGTIOUGenerator(@Nullable IdentifierGenerationStrategy generator) {
        this.pgtIOUGenerator = generator;
    }

    public void setPGTIOUGeneratorLookupStrategy(@Nullable Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.pgtIOUGeneratorLookupStrategy = strategy;
    }

    @Nonnull
    public Comparator<String> getServiceComparator() {
        return (Comparator)Constraint.isNotNull((Object)this.getIndirectProperty(this.serviceComparatorLookupStrategy, this.serviceComparator), (String)"Service comparator cannot be null");
    }

    public void setServiceComparator(@Nullable Comparator<String> comparator) {
        this.serviceComparator = comparator;
    }

    public void setServiceComparatorLookupStrategy(@Nullable Function<ProfileRequestContext, Comparator<String>> strategy) {
        this.serviceComparatorLookupStrategy = strategy;
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getDefaultTicketPrefix() {
        return DEFAULT_TICKET_PREFIX;
    }

    @Override
    protected int getDefaultTicketLength() {
        return 50;
    }

    @Nullable
    public String getUserAttribute() {
        return (String)this.getIndirectProperty(this.userAttributeLookupStrategy, this.userAttribute);
    }

    public void setUserAttribute(@Nullable String attribute) {
        this.userAttribute = attribute;
    }

    public void setUserAttributeLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.userAttributeLookupStrategy = strategy;
    }
}

