/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.proxy.impl;

import com.beust.jcommander.internal.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import net.shibboleth.idp.cas.proxy.impl.AbstractProxyAuthenticator;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProxyAuthenticator
extends AbstractProxyAuthenticator {
    private static final int DEFAULT_TIMEOUT = 800;
    private final Logger log = LoggerFactory.getLogger(HttpClientProxyAuthenticator.class);
    @Positive
    private int t = 800;

    public void setTimeout(@Positive int timeout) {
        this.t = (int)Constraint.isGreaterThan((long)0L, (long)timeout, (String)"Timeout must be positive");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int authenticateProxyCallback(@Nonnull URI callbackUri, @Nullable TrustEngine<? super X509Credential> x509TrustEngine) throws GeneralSecurityException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = this.createHttpClient(x509TrustEngine);
            this.log.debug("Attempting to connect to {}", (Object)callbackUri);
            HttpGet request = new HttpGet(callbackUri);
            request.setConfig(RequestConfig.custom().setConnectTimeout(this.t).setSocketTimeout(this.t).build());
            response = httpClient.execute((HttpUriRequest)request);
            int n = response.getStatusLine().getStatusCode();
            this.close((Closeable)response);
            this.close((Closeable)httpClient);
            return n;
        }
        catch (ClientProtocolException e) {
            try {
                throw new GeneralSecurityException("HTTP protocol error", e);
                catch (SSLException e2) {
                    if (e2.getCause() instanceof CertificateException) {
                        throw (CertificateException)e2.getCause();
                    }
                    throw new GeneralSecurityException("SSL connection error", e2);
                }
                catch (IOException e3) {
                    throw new GeneralSecurityException("IO error", e3);
                }
            }
            catch (Throwable throwable) {
                this.close((Closeable)response);
                this.close((Closeable)httpClient);
                throw throwable;
            }
        }
    }

    private CloseableHttpClient createHttpClient(TrustEngine<? super X509Credential> x509TrustEngine) {
        SSLConnectionSocketFactory socketFactory;
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(null, (TrustStrategy)new TrustEngineTrustStrategy(x509TrustEngine)).build();
            socketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            throw new RuntimeException("SSL initialization error", e);
        }
        Registry registry = RegistryBuilder.create().register("https", (Object)socketFactory).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)registry);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    private void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                this.log.warn("Error closing " + resource, (Throwable)e);
            }
        }
    }

    private static class TrustEngineTrustStrategy
    implements TrustStrategy {
        private final TrustEngine<? super X509Credential> trustEngine;
        private final Logger log = LoggerFactory.getLogger(TrustEngineTrustStrategy.class);

        public TrustEngineTrustStrategy(TrustEngine<? super X509Credential> engine) {
            this.trustEngine = engine;
        }

        public boolean isTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            if (this.trustEngine == null || certificates == null || certificates.length < 1) {
                return false;
            }
            try {
                this.log.debug("Validating cert {} issued by {}", (Object)certificates[0].getSubjectDN().getName(), (Object)certificates[0].getIssuerDN().getName());
                return this.trustEngine.validate((Object)new BasicX509Credential(certificates[0]), new CriteriaSet());
            }
            catch (SecurityException e) {
                throw new CertificateException("X509 validation error", e);
            }
        }
    }
}

