/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class BuildProxyChainAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private final Logger log = LoggerFactory.getLogger(BuildProxyChainAction.class);
    @Nonnull
    private final TicketServiceEx ticketServiceEx;

    public BuildProxyChainAction(@Nonnull TicketServiceEx ticketService) {
        this.ticketServiceEx = (TicketServiceEx)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        ProxyGrantingTicket pgt;
        TicketValidationResponse response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        Ticket ticket = this.getCASTicket(profileRequestContext);
        if (!(ticket instanceof ProxyTicket)) {
            return ProtocolError.InvalidTicketType.event((Object)this);
        }
        ProxyTicket pt = (ProxyTicket)ticket;
        String pgtId = pt.getPgtId();
        do {
            if ((pgt = this.ticketServiceEx.fetchProxyGrantingTicket(pgtId)) == null) {
                this.log.debug("PGT {} not found", (Object)pgtId);
                return ProtocolError.BrokenProxyChain.event((Object)this);
            }
            response.addProxy(pgt.getService());
        } while ((pgtId = pgt.getParentId()) != null);
        return null;
    }
}

