/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.cas.config.impl.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.impl.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.TicketPrincipalLookupFunction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrepareTicketValidationResponseAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private final Logger log = LoggerFactory.getLogger(PrepareTicketValidationResponseAction.class);
    private Function<ProfileRequestContext, AttributeContext> attributeContextFunction = Functions.compose((Function)new ChildContextLookup(AttributeContext.class, true), (Function)new ChildContextLookup(RelyingPartyContext.class));
    private Function<ProfileRequestContext, String> principalLookupFunction = new TicketPrincipalLookupFunction();
    private final ConfigLookupFunction<ValidateConfiguration> configLookupFunction = new ConfigLookupFunction<ValidateConfiguration>(ValidateConfiguration.class);

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        String principal;
        AttributeContext ac = (AttributeContext)this.attributeContextFunction.apply((Object)profileRequestContext);
        if (ac == null) {
            throw new IllegalStateException("AttributeContext not found in profile request context.");
        }
        ValidateConfiguration validateConfiguration = this.configLookupFunction.apply(profileRequestContext);
        if (validateConfiguration == null) {
            throw new IllegalArgumentException("Cannot locate ValidateConfiguration");
        }
        if (validateConfiguration.getUserAttribute() != null) {
            this.log.debug("Using {} for CAS username", (Object)validateConfiguration.getUserAttribute());
            IdPAttribute attribute = (IdPAttribute)ac.getIdPAttributes().get(validateConfiguration.getUserAttribute());
            if (attribute != null && !attribute.getValues().isEmpty()) {
                principal = ((IdPAttributeValue)attribute.getValues().get(0)).getValue().toString();
            } else {
                this.log.debug("Filtered attribute {} has no value", (Object)validateConfiguration.getUserAttribute());
                principal = null;
            }
        } else {
            principal = (String)this.principalLookupFunction.apply((Object)profileRequestContext);
        }
        if (principal == null) {
            throw new IllegalStateException("Principal cannot be null");
        }
        TicketValidationResponse response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        response.setUserName(principal);
        for (IdPAttribute attribute : ac.getIdPAttributes().values()) {
            this.log.debug("Processing {}", (Object)attribute);
            for (IdPAttributeValue value : attribute.getValues()) {
                response.addAttribute(attribute.getId(), value.getValue().toString());
            }
        }
        return null;
    }
}

