/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.impl.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.impl.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.proxy.ProxyAuthenticator;
import net.shibboleth.idp.cas.proxy.ProxyIdentifiers;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketServiceEx;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.utils.URIBuilder;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidateProxyCallbackAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private final Logger log = LoggerFactory.getLogger(ValidateProxyCallbackAction.class);
    private final ConfigLookupFunction<ValidateConfiguration> configLookupFunction = new ConfigLookupFunction<ValidateConfiguration>(ValidateConfiguration.class);
    @Nonnull
    private final ProxyAuthenticator<TrustEngine<? super X509Credential>> proxyAuthnticator;
    @Nonnull
    private final TicketServiceEx ticketServiceEx;

    public ValidateProxyCallbackAction(@Nonnull ProxyAuthenticator<TrustEngine<? super X509Credential>> proxyAuthenticator, @Nonnull TicketServiceEx ticketService) {
        this.proxyAuthnticator = (ProxyAuthenticator)Constraint.isNotNull(proxyAuthenticator, (String)"ProxyAuthenticator cannot be null");
        this.ticketServiceEx = (TicketServiceEx)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        URI proxyCallbackUri;
        TicketValidationRequest request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
        TicketValidationResponse response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        Ticket ticket = this.getCASTicket(profileRequestContext);
        ValidateConfiguration config = this.configLookupFunction.apply(profileRequestContext);
        if (config == null) {
            throw new IllegalStateException("Proxy-granting ticket configuration undefined");
        }
        if (config.getSecurityConfiguration() == null || config.getSecurityConfiguration().getIdGenerator() == null) {
            throw new IllegalStateException("Invalid proxy-granting ticket configuration: SecurityConfiguration#idGenerator undefined");
        }
        if (config.getPGTIOUGenerator() == null) {
            throw new IllegalStateException("Invalid proxy-granting ticket configuration: PGTIOUGenerator undefined");
        }
        ProxyIdentifiers proxyIds = new ProxyIdentifiers(config.getSecurityConfiguration().getIdGenerator().generateIdentifier(), config.getPGTIOUGenerator().generateIdentifier());
        try {
            proxyCallbackUri = new URIBuilder(request.getPgtUrl()).addParameter(ProtocolParam.PgtId.id(), proxyIds.getPgtId()).addParameter(ProtocolParam.PgtIou.id(), proxyIds.getPgtIou()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error creating proxy callback URL", e);
        }
        try {
            TrustEngine engine;
            this.log.debug("Attempting proxy authentication to {}", (Object)proxyCallbackUri);
            if (config.getSecurityConfiguration().getClientTLSValidationConfiguration() != null) {
                engine = config.getSecurityConfiguration().getClientTLSValidationConfiguration().getX509TrustEngine();
            } else {
                this.log.debug("Proxy-granting ticket configuration does not define ClientTLSValidationConfiguration");
                engine = null;
            }
            this.proxyAuthnticator.authenticate(proxyCallbackUri, (Object)engine);
            Instant expiration = DateTime.now().plus(config.getTicketValidityPeriod()).toInstant();
            if (ticket instanceof ServiceTicket) {
                this.ticketServiceEx.createProxyGrantingTicket(proxyIds.getPgtId(), expiration, (ServiceTicket)ticket);
            } else {
                this.ticketServiceEx.createProxyGrantingTicket(proxyIds.getPgtId(), expiration, (ProxyTicket)ticket);
            }
            response.setPgtIou(proxyIds.getPgtIou());
        }
        catch (Exception e) {
            this.log.info("Proxy authentication failed for " + request.getPgtUrl() + ": " + e);
            return ProtocolError.ProxyCallbackAuthenticationFailure.event((Object)this);
        }
        return null;
    }
}

