/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.SamlParam;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.opensaml.saml.saml1.core.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ProcessSamlMessageAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessSamlMessageAction.class);

    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        profileRequestContext.setProfileId("https://www.apereo.org/cas/protocol/serviceValidate");
        ParameterMap params = springRequestContext.getRequestParameters();
        String service = params.get(SamlParam.TARGET.name());
        if (service == null) {
            return ProtocolError.ServiceNotSpecified.event((Object)this);
        }
        MessageContext msgContext = profileRequestContext.getInboundMessageContext();
        String ticket = null;
        if (msgContext.getMessage() instanceof Request) {
            Request request = (Request)msgContext.getMessage();
            Iterator i$ = request.getAssertionArtifacts().iterator();
            if (i$.hasNext()) {
                AssertionArtifact artifact = (AssertionArtifact)i$.next();
                ticket = artifact.getAssertionArtifact();
            }
        } else {
            this.log.info("Unexpected SAMLObject type {}", (Object)((SAMLObject)msgContext.getMessage()).getClass().getName());
            return ProtocolError.ProtocolViolation.event((Object)this);
        }
        if (ticket == null) {
            return ProtocolError.TicketNotSpecified.event((Object)this);
        }
        TicketValidationRequest ticketValidationRequest = new TicketValidationRequest(service, ticket);
        String renew = params.get(ProtocolParam.Renew.id());
        if (renew != null) {
            ticketValidationRequest.setRenew(true);
        }
        this.setCASRequest(profileRequestContext, ticketValidationRequest);
        return null;
    }
}

