/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WriteValidateResponseAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    private static final String CONTENT_TYPE = "text/plain;charset=utf-8";
    private final boolean success;

    public WriteValidateResponseAction(boolean successFlag) {
        this.success = successFlag;
    }

    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        TicketValidationResponse response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        try {
            HttpServletResponse servletResponse = (HttpServletResponse)springRequestContext.getExternalContext().getNativeResponse();
            servletResponse.setContentType(CONTENT_TYPE);
            PrintWriter output = servletResponse.getWriter();
            if (this.success) {
                output.print("yes\n");
                output.print(response.getUserName() + '\n');
            } else {
                output.print("no\n\n");
            }
            output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error writing CAS protocol response", e);
        }
        return null;
    }
}

