/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.LoginConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;

public class BuildAuthenticationContextAction
extends AbstractCASProtocolAction<ServiceTicketRequest, ServiceTicketResponse> {
    @Nonnull
    private final ConfigLookupFunction<LoginConfiguration> configLookupFunction = new ConfigLookupFunction(LoginConfiguration.class);
    @Nullable
    private ServiceTicketRequest request;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.request = (ServiceTicketRequest)this.getCASRequest(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    @Nonnull
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuthenticationContext ac = new AuthenticationContext();
        ac.setForceAuthn(this.request.isRenew());
        ac.setIsPassive(false);
        LoginConfiguration config = (LoginConfiguration)this.configLookupFunction.apply(profileRequestContext);
        if (!ac.isForceAuthn() && config != null) {
            ac.setForceAuthn(config.isForceAuthn(profileRequestContext));
        }
        if (config != null) {
            ac.setProxyCount(config.getProxyCount(profileRequestContext));
        }
        profileRequestContext.addSubcontext((BaseContext)ac, true);
        profileRequestContext.setBrowserProfile(true);
    }
}

