/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.service.Service;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckProxyAuthorizationAction<RequestType, ResponseType>
extends AbstractCASProtocolAction<RequestType, ResponseType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckProxyAuthorizationAction.class);
    @Nullable
    private Service service;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.service = this.getCASService(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.service.isAuthorizedToProxy()) {
            this.log.info("{} Service '{}' is not authorized to proxy", (Object)this.getLogPrefix(), (Object)this.service.getName());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.ProxyNotAuthorized.event((Object)this));
        }
    }
}

