/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectContextPrincipalLookupFunction;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.LoginConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.idp.cas.protocol.ServiceTicketResponse;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrantServiceTicketAction
extends AbstractCASProtocolAction<ServiceTicketRequest, ServiceTicketResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GrantServiceTicketAction.class);
    @Nonnull
    private final ConfigLookupFunction<LoginConfiguration> configLookupFunction;
    @Nonnull
    private final Function<ProfileRequestContext, SessionContext> sessionContextFunction;
    @Nonnull
    private final Function<ProfileRequestContext, AuthenticationContext> authnCtxLookupFunction;
    @Nonnull
    private final Function<ProfileRequestContext, String> principalLookupFunction;
    @Nonnull
    private final TicketService casTicketService;
    @Nullable
    private LoginConfiguration loginConfig;
    @Nullable
    private SecurityConfiguration securityConfig;
    @Nullable
    private IdPSession session;
    @Nullable
    private AuthenticationResult authnResult;
    @Nullable
    private ServiceTicketRequest request;

    public GrantServiceTicketAction(@Nonnull TicketService ticketService) {
        this.casTicketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
        this.configLookupFunction = new ConfigLookupFunction(LoginConfiguration.class);
        this.sessionContextFunction = new ChildContextLookup(SessionContext.class);
        this.authnCtxLookupFunction = new ChildContextLookup(AuthenticationContext.class);
        this.principalLookupFunction = new SubjectContextPrincipalLookupFunction().compose((Function)new ChildContextLookup(SubjectContext.class));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.loginConfig = (LoginConfiguration)this.configLookupFunction.apply(profileRequestContext);
        if (this.loginConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.securityConfig = this.loginConfig.getSecurityConfiguration(profileRequestContext);
        if (this.securityConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        try {
            this.request = (ServiceTicketRequest)this.getCASRequest(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        this.session = this.getIdPSession(profileRequestContext);
        if (this.session == null) {
            this.log.warn("{} No IdP session found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        AuthenticationContext authnCtx = this.authnCtxLookupFunction.apply(profileRequestContext);
        this.authnResult = authnCtx != null ? authnCtx.getAuthenticationResult() : this.getLatestAuthenticationResult();
        if (this.authnResult == null) {
            this.log.warn("{} No AuthenticationResult found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ServiceTicket ticket;
        try {
            this.log.debug("{} Granting service ticket for {}", (Object)this.getLogPrefix(), (Object)this.request.getService());
            TicketState state = new TicketState(this.session.getId(), this.getPrincipalName(profileRequestContext), this.authnResult.getAuthenticationInstant(), this.authnResult.getAuthenticationFlowId());
            ticket = this.casTicketService.createServiceTicket(this.securityConfig.getIdGenerator().generateIdentifier(), Instant.now().plus(this.loginConfig.getTicketValidityPeriod(profileRequestContext)), this.request.getService(), state, this.request.isRenew());
        }
        catch (RuntimeException e) {
            this.log.error("{} Failed granting service ticket due to error.", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.TicketCreationError.event((Object)this));
            return;
        }
        ServiceTicketResponse response = new ServiceTicketResponse(this.request.getService(), ticket.getId());
        if (this.request.isSAML()) {
            response.setSaml(true);
        }
        try {
            this.setCASResponse(profileRequestContext, response);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return;
        }
        this.log.info("{} Granted service ticket for {}", (Object)this.getLogPrefix(), (Object)this.request.getService());
    }

    @Nullable
    private IdPSession getIdPSession(ProfileRequestContext prc) {
        SessionContext sessionContext = this.sessionContextFunction.apply(prc);
        return sessionContext != null ? sessionContext.getIdPSession() : null;
    }

    @Nonnull
    private String getPrincipalName(ProfileRequestContext prc) {
        String principal = this.principalLookupFunction.apply(prc);
        if (principal == null) {
            throw new IllegalStateException("Cannot determine IdP subject principal name.");
        }
        return principal;
    }

    @Nullable
    private AuthenticationResult getLatestAuthenticationResult() {
        AuthenticationResult latest = null;
        for (AuthenticationResult result : this.session.getAuthenticationResults()) {
            if (latest != null && !result.getAuthenticationInstant().isAfter(latest.getAuthenticationInstant())) continue;
            latest = result;
        }
        return latest;
    }
}

