/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.proxy.impl;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.FailedLoginException;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.proxy.ProxyValidator;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProxyValidator
implements ProxyValidator {
    @Nonnull
    @NotEmpty
    protected static final String HTTPS_SCHEME = "https";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HttpClientProxyValidator.class);
    @Nonnull
    private final Function<ProfileRequestContext, ServiceContext> serviceCtxLookupFunction = new ChildContextLookup(ServiceContext.class).compose((Function)new ChildContextLookup(ProtocolContext.class));
    @Nonnull
    private final HttpClient httpClient;
    @Nonnull
    private final HttpClientSecurityParameters securityParameters;
    @NotEmpty
    @NonnullElements
    private Set<Integer> allowedResponseCodes = Collections.singleton(200);

    public HttpClientProxyValidator(@Nonnull HttpClient client, @Nonnull HttpClientSecurityParameters parameters) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HTTP client cannot be null");
        this.securityParameters = (HttpClientSecurityParameters)Constraint.isNotNull((Object)parameters, (String)"HTTP client security parameters cannot be null");
    }

    public void setAllowedResponseCodes(@NotEmpty @NonnullElements Set<Integer> responseCodes) {
        Constraint.isNotEmpty(responseCodes, (String)"Response codes cannot be null or empty.");
        Constraint.noNullItems((Object[])responseCodes.toArray(), (String)"Response codes cannot contain null elements.");
        this.allowedResponseCodes = responseCodes;
    }

    public void validate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull URI proxyCallbackUri) throws GeneralSecurityException {
        Constraint.isNotNull((Object)proxyCallbackUri, (String)"Proxy callback URI cannot be null");
        if (!HTTPS_SCHEME.equalsIgnoreCase(proxyCallbackUri.getScheme())) {
            throw new GeneralSecurityException(proxyCallbackUri + " is not an https URI as required.");
        }
        ServiceContext serviceContext = this.serviceCtxLookupFunction.apply(profileRequestContext);
        if (serviceContext == null) {
            throw new IllegalStateException("Service context not found in profile request context as required");
        }
        int status = this.connect(proxyCallbackUri, serviceContext.getService());
        if (!this.allowedResponseCodes.contains(status)) {
            throw new FailedLoginException(proxyCallbackUri + " returned unacceptable HTTP status code: " + status);
        }
    }

    protected int connect(@Nonnull URI uri, @Nonnull Service service) throws GeneralSecurityException {
        HttpClientContext clientContext = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.securityParameters, (boolean)true);
        HttpClientProxyValidator.setCASTLSTrustEngineCriteria(clientContext, uri, service);
        try {
            this.log.debug("Attempting to validate CAS proxy callback URI {}", (Object)uri);
            HttpGet request = new HttpGet(uri);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)clientContext);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)request.getURI().getScheme());
            return response.getStatusLine().getStatusCode();
        }
        catch (ClientProtocolException e) {
            throw new GeneralSecurityException("HTTP protocol error", e);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new CredentialException("Untrusted certificate presented by CAS proxy callback endpoint");
        }
        catch (SSLException e) {
            if (e.getCause() instanceof CertificateException) {
                throw (CertificateException)e.getCause();
            }
            throw new GeneralSecurityException("SSL connection error", e);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("IO error", e);
        }
    }

    private static void setCASTLSTrustEngineCriteria(HttpClientContext context, URI requestUri, Service service) {
        String entityID = service.getEntityDescriptor() != null ? service.getEntityDescriptor().getEntityID() : service.getName();
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("https://www.apereo.org/cas/protocol"), new UsageCriterion(UsageType.SIGNING), new TrustedNamesCriterion(Collections.singleton(requestUri.getHost()))});
        context.setAttribute("opensaml.CriteriaSet", (Object)criteria);
    }
}

