/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyGrantingTicketSerializer;
import net.shibboleth.idp.cas.ticket.serialization.impl.ProxyTicketSerializer;
import net.shibboleth.idp.cas.ticket.serialization.impl.ServiceTicketSerializer;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTicketService
implements TicketService {
    private static final Map<Class<? extends Ticket>, String> CONTEXT_CLASS_MAP = new HashMap<Class<? extends Ticket>, String>();
    private static final Map<Class<? extends Ticket>, StorageSerializer<? extends Ticket>> SERIALIZER_MAP = new HashMap<Class<? extends Ticket>, StorageSerializer<? extends Ticket>>();
    private static final ServiceTicketSerializer ST_SERIALIZER = new ServiceTicketSerializer();
    private static final ProxyTicketSerializer PT_SERIALIZER = new ProxyTicketSerializer();
    private static final ProxyGrantingTicketSerializer PGT_SERIALIZER = new ProxyGrantingTicketSerializer();
    private final Logger log = LoggerFactory.getLogger(AbstractTicketService.class);
    @Nonnull
    private final StorageService storageService;

    public AbstractTicketService(@Nonnull StorageService service) {
        this.storageService = (StorageService)Constraint.isNotNull((Object)service, (String)"StorageService cannot be null.");
    }

    @Nonnull
    public ProxyGrantingTicket createProxyGrantingTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ServiceTicket serviceTicket) {
        Constraint.isNotNull((Object)serviceTicket, (String)"ServiceTicket cannot be null");
        ProxyGrantingTicket pgt = new ProxyGrantingTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), serviceTicket.getService(), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), null);
        pgt.setTicketState(serviceTicket.getTicketState());
        this.store(pgt);
        return pgt;
    }

    @Nonnull
    public ProxyGrantingTicket createProxyGrantingTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ProxyTicket proxyTicket) {
        Constraint.isNotNull((Object)proxyTicket, (String)"ProxyTicket cannot be null");
        ProxyGrantingTicket pgt = new ProxyGrantingTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), proxyTicket.getService(), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), proxyTicket.getPgtId());
        pgt.setTicketState(proxyTicket.getTicketState());
        this.store(pgt);
        return pgt;
    }

    @Nullable
    public ProxyGrantingTicket fetchProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        return this.read(id, ProxyGrantingTicket.class);
    }

    @Nullable
    public ProxyGrantingTicket removeProxyGrantingTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        ProxyGrantingTicket pgt = this.delete(id, ProxyGrantingTicket.class);
        return pgt;
    }

    protected static String context(Class<? extends Ticket> clazz) {
        return CONTEXT_CLASS_MAP.get(clazz);
    }

    protected static <T extends Ticket> StorageSerializer<T> serializer(Class<T> clazz) {
        return SERIALIZER_MAP.get(clazz);
    }

    protected <T extends Ticket> void store(T ticket) {
        String context = AbstractTicketService.context(ticket.getClass());
        try {
            String sessionId = ticket.getSessionId();
            long expiry = ticket.getExpirationInstant().toEpochMilli();
            this.log.debug("Storing mapping of {} to {} in context {}", new Object[]{ticket, sessionId, context});
            if (!this.storageService.create(context, ticket.getId(), sessionId, Long.valueOf(expiry))) {
                throw new RuntimeException("Failed to store ticket " + ticket);
            }
            this.log.debug("Storing {} in context {}", ticket, (Object)sessionId);
            if (!this.storageService.create(sessionId, ticket.getId(), ticket, AbstractTicketService.serializer(ticket.getClass()), Long.valueOf(expiry))) {
                throw new RuntimeException("Failed to store ticket " + ticket);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to store ticket " + ticket, e);
        }
    }

    protected <T extends Ticket> T read(String id, Class<T> clazz) {
        Ticket ticket;
        this.log.debug("Reading {}", (Object)id);
        try {
            String context = AbstractTicketService.context(clazz);
            StorageRecord sessionRecord = this.storageService.read(context, id);
            if (sessionRecord == null) {
                this.log.debug("{} not found in context {}", (Object)id, (Object)context);
                return null;
            }
            String sessionId = sessionRecord.getValue();
            StorageRecord ticketRecord = this.storageService.read(sessionId, id);
            if (ticketRecord == null) {
                this.log.debug("{} not found in context {}", (Object)id, (Object)sessionId);
                return null;
            }
            ticket = (Ticket)ticketRecord.getValue(AbstractTicketService.serializer(clazz), sessionId, id);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ticket.");
        }
        return (T)ticket;
    }

    protected <T extends Ticket> T delete(String id, Class<T> clazz) {
        T ticket = this.read(id, clazz);
        if (ticket == null) {
            return null;
        }
        try {
            String context = AbstractTicketService.context(clazz);
            this.log.debug("Attempting to delete {} from context {}", (Object)id, (Object)context);
            if (!this.storageService.delete(context, id)) {
                this.log.info("Failed deleting {} from context {}.", (Object)id, (Object)context);
            }
            String sessionId = ticket.getSessionId();
            this.log.debug("Attempting to delete {} from context {}", (Object)id, (Object)sessionId);
            if (!this.storageService.delete(sessionId, id)) {
                this.log.info("Failed deleting {} from context {}.", (Object)id, (Object)sessionId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting ticket " + id, e);
        }
        return ticket;
    }

    static {
        CONTEXT_CLASS_MAP.put(ServiceTicket.class, "https://www.apereo.org/cas/protocol/login");
        CONTEXT_CLASS_MAP.put(ProxyTicket.class, "https://www.apereo.org/cas/protocol/proxy");
        CONTEXT_CLASS_MAP.put(ProxyGrantingTicket.class, "https://www.apereo.org/cas/protocol/serviceValidate");
        SERIALIZER_MAP.put(ServiceTicket.class, ST_SERIALIZER);
        SERIALIZER_MAP.put(ProxyTicket.class, PT_SERIALIZER);
        SERIALIZER_MAP.put(ProxyGrantingTicket.class, PGT_SERIALIZER);
    }
}

