/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.AbstractTicketService;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingTicketService
extends AbstractTicketService {
    public static final String SERVICE_TICKET_PREFIX = "ST";
    public static final String PROXY_TICKET_PREFIX = "PT";
    private static final String NOT_USED = "na";
    private final Logger log = LoggerFactory.getLogger(EncodingTicketService.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NotEmpty
    private String serviceTicketPrefix = "ST";
    @NotEmpty
    private String proxyTicketPrefix = "PT";

    public EncodingTicketService(@Nonnull @ParameterName(name="service") StorageService service, @Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        super(service);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setServiceTicketPrefix(String prefix) {
        this.serviceTicketPrefix = Constraint.isNotEmpty((String)prefix, (String)"Prefix cannot be null or empty");
    }

    public void setProxyTicketPrefix(String prefix) {
        this.proxyTicketPrefix = Constraint.isNotEmpty((String)prefix, (String)"Prefix cannot be null or empty");
    }

    @Nonnull
    public ServiceTicket createServiceTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull String service, @Nullable TicketState state, boolean renew) {
        Constraint.isNotNull((Object)state, (String)"State cannot be null");
        ServiceTicket st = new ServiceTicket((String)Constraint.isNotNull((Object)id, (String)"ID cannot be null"), (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), renew);
        st.setTicketState(state);
        return this.encode(ServiceTicket.class, st, this.serviceTicketPrefix);
    }

    @Nullable
    public ServiceTicket removeServiceTicket(@Nonnull String id) {
        Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        return this.decode(ServiceTicket.class, id, this.serviceTicketPrefix);
    }

    @Nonnull
    public ProxyTicket createProxyTicket(@Nonnull String id, @Nonnull Instant expiry, @Nonnull ProxyGrantingTicket pgt, @Nonnull String service) {
        Constraint.isNotNull((Object)pgt, (String)"ProxyGrantingTicket cannot be null");
        ProxyTicket pt = new ProxyTicket(NOT_USED, (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null"), (Instant)Constraint.isNotNull((Object)expiry, (String)"Expiry cannot be null"), pgt.getId());
        pt.setTicketState(pgt.getTicketState());
        return this.encode(ProxyTicket.class, pt, this.proxyTicketPrefix);
    }

    @Nullable
    public ProxyTicket removeProxyTicket(@Nonnull String id) {
        return this.decode(ProxyTicket.class, id, this.proxyTicketPrefix);
    }

    private <T extends Ticket> T encode(Class<T> ticketClass, T ticket, String prefix) {
        String opaque;
        try {
            opaque = this.dataSealer.wrap(EncodingTicketService.serializer(ticketClass).serialize(ticket), ticket.getExpirationInstant());
        }
        catch (Exception e) {
            throw new RuntimeException("Ticket encoding failed", e);
        }
        return (T)((Ticket)ticketClass.cast(ticket.clone(prefix + "-" + opaque)));
    }

    private <T extends Ticket> T decode(Class<T> ticketClass, String id, String prefix) {
        try {
            String decrypted = this.dataSealer.unwrap(id.substring(prefix.length() + 1));
            return (T)((Ticket)EncodingTicketService.serializer(ticketClass).deserialize(0L, NOT_USED, id, decrypted, Long.valueOf(0L)));
        }
        catch (Exception e) {
            this.log.warn("Ticket decoding failed with error: " + e.getMessage());
            this.log.debug("Ticket decoding failed", (Throwable)e);
            return null;
        }
    }
}

