/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.attribute.transcoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.cas.attribute.AbstractCASAttributeTranscoder;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CASScopedStringAttributeTranscoder
extends AbstractCASAttributeTranscoder<ScopedStringAttributeValue> {
    @Nonnull
    @NotEmpty
    public static final String PROP_SCOPE_DELIMITER = "cas.scopeDelimiter";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CASScopedStringAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof ScopedStringAttributeValue;
    }

    @Nullable
    protected String encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull ScopedStringAttributeValue value) throws AttributeEncodingException {
        String scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)"@");
        return value.getValue() + scopeDelimiter + value.getScope();
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable String value) {
        if (value == null) {
            return null;
        }
        String scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)"@");
        int offset = value.indexOf(scopeDelimiter);
        if (offset < 0) {
            this.log.warn("Ignoring value with no scope delimiter ({})", (Object)scopeDelimiter);
            return null;
        }
        return ScopedStringAttributeValue.valueOf((String)value.substring(0, offset), (String)value.substring(offset + scopeDelimiter.length()));
    }
}

