/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class InitializeProxyAction
extends AbstractCASProtocolAction<ProxyTicketRequest, ProxyTicketResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeProxyAction.class);
    @Nonnull
    private final TicketService casTicketService;

    public InitializeProxyAction(@Nonnull TicketService ticketService) {
        this.casTicketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"Ticket service cannot be null.");
    }

    @Nonnull
    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        String ticket;
        ParameterMap params = springRequestContext.getRequestParameters();
        String service = params.get(ProtocolParam.TargetService.id());
        Event result = null;
        if (service == null) {
            service = ProtocolError.ServiceNotSpecified.getDetailCode();
            result = ProtocolError.ServiceNotSpecified.event((Object)this);
        }
        if ((ticket = params.get(ProtocolParam.Pgt.id())) == null) {
            ticket = ProtocolError.TicketNotSpecified.getDetailCode();
            result = ProtocolError.TicketNotSpecified.event((Object)this);
        }
        ProxyTicketRequest proxyTicketRequest = new ProxyTicketRequest(ticket, service);
        try {
            this.setCASRequest(profileRequestContext, proxyTicketRequest);
        }
        catch (EventException e) {
            return ActionSupport.buildEvent((Object)((Object)this), (String)e.getEventID());
        }
        if (result == null) {
            try {
                this.log.debug("{} Fetching proxy-granting ticket {}", (Object)this.getLogPrefix(), (Object)proxyTicketRequest.getPgt());
                ProxyGrantingTicket pgt = this.casTicketService.fetchProxyGrantingTicket(proxyTicketRequest.getPgt());
                if (pgt == null) {
                    return ProtocolError.TicketExpired.event((Object)this);
                }
                this.setCASTicket(profileRequestContext, (Ticket)pgt);
            }
            catch (Exception e) {
                this.log.error("{} Failed looking up {}", new Object[]{this.getLogPrefix(), proxyTicketRequest.getPgt(), e});
                return ProtocolError.TicketRetrievalError.event((Object)this);
            }
        }
        return result;
    }
}

