/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.session.impl.CASSPSession;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateIdPSessionWithSPSessionAction<RequestType, ResponseType>
extends AbstractCASProtocolAction<RequestType, ResponseType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateIdPSessionWithSPSessionAction.class);
    @Nonnull
    private final SessionResolver sessionResolver;
    @Nonnull
    private final Duration sessionLifetime;
    @Nullable
    private Ticket ticket;
    @Nullable
    private Service service;

    public UpdateIdPSessionWithSPSessionAction(@Nonnull SessionResolver resolver, @Nonnull Duration lifetime) {
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"Session resolver cannot be null");
        this.sessionLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.service = this.getCASService(profileRequestContext);
            if (!this.service.isSingleLogoutParticipant()) {
                return false;
            }
            this.ticket = this.getCASTicket(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    @Nonnull
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        IdPSession session = null;
        try {
            this.log.debug("{} Attempting to retrieve session {}", (Object)this.getLogPrefix(), (Object)this.ticket.getSessionId());
            session = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion(this.ticket.getSessionId())}));
        }
        catch (ResolverException e) {
            this.log.warn("{} Possible sign of misconfiguration, IdPSession resolution error: {}", (Object)this.getLogPrefix(), (Object)e);
        }
        if (session != null) {
            Instant now = Instant.now();
            CASSPSession sps = new CASSPSession(this.ticket.getService(), now, now.plus(this.sessionLifetime), this.ticket.getId());
            this.log.debug("{} Created SP session {}", (Object)this.getLogPrefix(), (Object)sps);
            try {
                session.addSPSession((SPSession)sps);
            }
            catch (SessionException e) {
                this.log.warn("{} Failed updating IdPSession with CASSPSession", (Object)this.getLogPrefix(), (Object)e);
            }
        } else {
            this.log.info("{} Cannot store CASSPSession since IdPSession not found", (Object)this.getLogPrefix());
        }
    }
}

