/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;

public class WriteValidateResponseAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    @NotEmpty
    private static final String CONTENT_TYPE = "text/plain;charset=utf-8";
    private final boolean success;
    @Nullable
    private TicketValidationResponse response;

    public WriteValidateResponseAction(boolean successFlag) {
        this.success = successFlag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.response = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            this.getHttpServletResponse().setContentType(CONTENT_TYPE);
            PrintWriter output = this.getHttpServletResponse().getWriter();
            if (this.success) {
                output.print("yes\n");
                output.print(this.response.getUserName() + "\n");
            } else {
                output.print("no\n\n");
            }
            output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error writing CAS protocol response", e);
        }
    }
}

