/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.protocol.ServiceTicketRequest;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class GatewayLookupFunction
implements Function<ProfileRequestContext, Boolean> {
    @Nonnull
    private final Function<ProfileRequestContext, ProtocolContext> protocolContextFunction;

    public GatewayLookupFunction() {
        this((Function<ProfileRequestContext, ProtocolContext>)new ChildContextLookup(ProtocolContext.class));
    }

    public GatewayLookupFunction(@Nonnull Function<ProfileRequestContext, ProtocolContext> protocolLookup) {
        this.protocolContextFunction = (Function)Constraint.isNotNull(protocolLookup, (String)"ProtocolContext lookup cannot be null");
    }

    @Override
    @Nullable
    public Boolean apply(@Nullable ProfileRequestContext input) {
        ProtocolContext protocolContext = this.protocolContextFunction.apply(input);
        if (protocolContext == null || protocolContext.getRequest() == null) {
            return null;
        }
        Object request = protocolContext.getRequest();
        if (request instanceof ServiceTicketRequest) {
            return ((ServiceTicketRequest)request).isGateway();
        }
        return null;
    }
}

