/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.idp.cas.attribute.transcoding.impl.CASStringAttributeTranscoder;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.TicketPrincipalLookupFunction;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PrepareTicketValidationResponseAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrepareTicketValidationResponseAction.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextFunction;
    @Nonnull
    private Function<ProfileRequestContext, String> principalLookupFunction;
    @Nonnull
    private final ConfigLookupFunction<ValidateConfiguration> configLookupFunction;
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @NonnullAfterInit
    private TranscodingRule defaultTranscodingRule;
    @NonnullBeforeExec
    private AttributeContext attributeContext;
    @Nullable
    private Set<String> consentedAttributeIds;
    @NonnullBeforeExec
    private ValidateConfiguration validateConfiguration;
    @NonnullBeforeExec
    private TicketValidationResponse ticketValidationResponse;

    public PrepareTicketValidationResponseAction() {
        Function acf = new ChildContextLookup(AttributeContext.class, true).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (acf != null);
        this.attributeContextFunction = acf;
        this.principalLookupFunction = new TicketPrincipalLookupFunction();
        this.configLookupFunction = new ConfigLookupFunction(ValidateConfiguration.class);
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.checkSetterPreconditions();
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
        CASStringAttributeTranscoder transcoder = new CASStringAttributeTranscoder();
        transcoder.initialize();
        this.defaultTranscodingRule = new TranscodingRule(CollectionSupport.singletonMap((Object)"transcoder", (Object)((Object)transcoder)));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeContext = this.attributeContextFunction.apply(profileRequestContext);
        if (this.attributeContext == null) {
            this.log.warn("{} AttributeContext not found in profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAttributeContext");
            return false;
        }
        this.validateConfiguration = (ValidateConfiguration)this.configLookupFunction.apply(profileRequestContext);
        if (this.validateConfiguration == null) {
            this.log.warn("{} Cannot locate ValidateConfiguration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        try {
            this.ticketValidationResponse = (TicketValidationResponse)this.getCASResponse(profileRequestContext);
            TicketState state = this.getCASTicket(profileRequestContext).getTicketState();
            if (state != null) {
                this.consentedAttributeIds = state.getConsentedAttributeIds();
            }
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String principal;
        String userAttributeName = this.validateConfiguration.getUserAttribute(profileRequestContext);
        if (userAttributeName != null) {
            this.log.debug("{} Using {} for CAS username", (Object)this.getLogPrefix(), (Object)userAttributeName);
            IdPAttribute attribute = (IdPAttribute)this.attributeContext.getIdPAttributes().get(userAttributeName);
            if (attribute != null && !attribute.getValues().isEmpty()) {
                IdPAttributeValue value = (IdPAttributeValue)attribute.getValues().get(0);
                if (value instanceof ScopedStringAttributeValue) {
                    ScopedStringAttributeValue scopedValue = (ScopedStringAttributeValue)value;
                    this.log.warn("{} Lossy use of attribute value {} from attribute {}", new Object[]{this.getLogPrefix(), scopedValue.getValue(), attribute.getId()});
                    principal = scopedValue.getValue();
                } else if (value instanceof StringAttributeValue) {
                    principal = ((StringAttributeValue)value).getValue();
                } else {
                    this.log.warn("{} Use of attribute value type {} from attribute {}", new Object[]{this.getLogPrefix(), value.getClass(), attribute.getId()});
                    principal = value.getNativeValue().toString();
                }
            } else {
                this.log.debug("{} Filtered attribute {} has no value", (Object)this.getLogPrefix(), (Object)userAttributeName);
                principal = null;
            }
        } else {
            principal = this.principalLookupFunction.apply(profileRequestContext);
        }
        if (principal == null) {
            throw new IllegalStateException("Principal cannot be null");
        }
        this.ticketValidationResponse.setUserName(principal);
        Collection inputAttributes = this.attributeContext.getIdPAttributes().values();
        ArrayList<Attribute> encodedAttributes = new ArrayList<Attribute>(inputAttributes.size());
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            for (IdPAttribute attribute : inputAttributes) {
                assert (attribute != null);
                Set<String> ids = this.consentedAttributeIds;
                if (ids == null || ids.contains(attribute.getId())) {
                    this.encodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, attribute, encodedAttributes);
                    continue;
                }
                this.log.info("{} Skipping attribute {} not in stored consent list from ticket", (Object)this.getLogPrefix(), (Object)attribute.getId());
            }
        }
        catch (ServiceException e) {
            this.log.error("{} Attribute transoding service unavailable", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
            return;
        }
        encodedAttributes.forEach(a -> {
            assert (a != null);
            this.ticketValidationResponse.addAttribute(a);
        });
    }

    protected int encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull @Live Collection<Attribute> results) {
        Collection transcodingRules = registry.getTranscodingRules(attribute, Attribute.class);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any transcoding rules, applying default", (Object)this.getLogPrefix(), (Object)attribute.getId());
            assert (this.defaultTranscodingRule != null);
            transcodingRules = CollectionSupport.singletonList((Object)this.defaultTranscodingRule);
        }
        int count = 0;
        for (TranscodingRule rules : transcodingRules) {
            assert (rules != null);
            try {
                AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
                Attribute encodedAttribute = (Attribute)transcoder.encode(profileRequestContext, attribute, Attribute.class, rules);
                if (encodedAttribute == null) continue;
                results.add(encodedAttribute);
                ++count;
            }
            catch (AttributeEncodingException e) {
                this.log.debug("{} Unable to encode attribute {}", new Object[]{this.getLogPrefix(), attribute.getId(), e});
            }
        }
        return count;
    }
}

