/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.config.ConfigLookupFunction;
import net.shibboleth.idp.cas.config.ValidateConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.flow.impl.Events;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketService;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateTicketAction
extends AbstractCASProtocolAction<TicketValidationRequest, TicketValidationResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateTicketAction.class);
    @Nonnull
    private final ConfigLookupFunction<ValidateConfiguration> configLookupFunction;
    @Nonnull
    private final TicketService casTicketService;
    @NonnullBeforeExec
    private ValidateConfiguration validateConfig;
    @NonnullBeforeExec
    private TicketValidationRequest request;

    public ValidateTicketAction(@Nonnull TicketService ticketService) {
        this.casTicketService = (TicketService)Constraint.isNotNull((Object)ticketService, (String)"TicketService cannot be null");
        this.configLookupFunction = new ConfigLookupFunction(ValidateConfiguration.class);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.validateConfig = (ValidateConfiguration)this.configLookupFunction.apply(profileRequestContext);
        if (this.validateConfig == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        try {
            this.request = (TicketValidationRequest)this.getCASRequest(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ServiceTicket ticket;
        try {
            String ticketId = this.request.getTicket();
            this.log.debug("Attempting to validate {}", (Object)ticketId);
            if (ticketId.startsWith("ST")) {
                ticket = this.casTicketService.removeServiceTicket(ticketId);
            } else if (ticketId.startsWith("PT")) {
                ticket = this.casTicketService.removeProxyTicket(ticketId);
            } else {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.InvalidTicketFormat.event((Object)this));
                return;
            }
            if (ticket != null) {
                this.log.debug("{} Found and removed {} from ticket store", (Object)this.getLogPrefix(), (Object)ticketId);
            }
        }
        catch (RuntimeException e) {
            this.log.debug("{} CAS ticket retrieval failed with error: {}", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.TicketRetrievalError.event((Object)this));
            return;
        }
        if (ticket == null || Instant.now().isAfter(ticket.getExpirationInstant())) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.TicketExpired.event((Object)this));
            return;
        }
        if (this.validateConfig.getServiceComparator(profileRequestContext).compare(ticket.getService(), this.request.getService()) != 0) {
            this.log.debug("{} Service issued for {} does not match {}", new Object[]{this.getLogPrefix(), ticket.getService(), this.request.getService()});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)ProtocolError.ServiceMismatch.event((Object)this));
            return;
        }
        try {
            this.setCASResponse(profileRequestContext, new TicketValidationResponse());
            this.setCASTicket(profileRequestContext, (Ticket)ticket);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return;
        }
        this.log.info("{} Successfully validated {} for {}", new Object[]{this.getLogPrefix(), this.request.getTicket(), this.request.getService()});
        if (ticket instanceof ProxyTicket) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)Events.ProxyTicketValidated.event((Object)this));
            return;
        }
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (Object)Events.ServiceTicketValidated.event((Object)this));
    }
}

