/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceRegistry;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;

public class ReloadingServiceRegistry
extends AbstractIdentifiableInitializableComponent
implements ServiceRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadingServiceRegistry.class);
    @Nonnull
    private final ReloadableService<ServiceRegistry> service;

    public ReloadingServiceRegistry(@Nonnull @ParameterName(name="delegate") ReloadableService<ServiceRegistry> delegate) {
        this.service = (ReloadableService)Constraint.isNotNull(delegate, (String)"ReloadableService cannot be null");
    }

    @Nullable
    public Service lookup(@Nonnull String serviceURL) {
        Service service;
        block8: {
            ServiceableComponent component = this.service.getServiceableComponent();
            try {
                service = ((ServiceRegistry)component.getComponent()).lookup(serviceURL);
                if (component == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (component != null) {
                        try {
                            component.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ServiceException e) {
                    this.log.error("ServiceRegistry '{}': Invalid CAS service registry configuration.", (Object)this.getId(), (Object)e);
                    return null;
                }
            }
            component.close();
        }
        return service;
    }
}

