/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.session.impl;

import jakarta.json.JsonObject;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.session.impl.CASSPSession;
import net.shibboleth.idp.session.AbstractSPSessionSerializer;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

public class CASSPSessionSerializer
extends AbstractSPSessionSerializer {
    @Nonnull
    @NotEmpty
    private static final String TICKET_FIELD = "st";
    @Nonnull
    @NotEmpty
    private static final String SERVICE_URL_FIELD = "surl";

    public CASSPSessionSerializer(@Nonnull @ParameterName(name="offset") Duration offset) {
        super(offset);
    }

    protected void doSerializeAdditional(@Nonnull SPSession instance, @Nonnull JsonGenerator generator) {
        if (!(instance instanceof CASSPSession)) {
            throw new IllegalArgumentException("Expected instance of CASSPSession but got " + instance);
        }
        CASSPSession casSession = (CASSPSession)instance;
        generator.write(TICKET_FIELD, casSession.getTicketId());
        if (!casSession.getServiceURL().equals(casSession.getId())) {
            generator.write(SERVICE_URL_FIELD, casSession.getServiceURL());
        }
    }

    @Nonnull
    protected SPSession doDeserialize(@Nonnull JsonObject obj, @Nonnull @NotEmpty String id, @Nonnull Instant creation, @Nonnull Instant expiration) throws IOException {
        String ticketField = (String)Constraint.isNotNull((Object)obj.getString(TICKET_FIELD), (String)"No ticket field");
        String serviceURL = obj.getString(SERVICE_URL_FIELD, id);
        assert (serviceURL != null);
        return new CASSPSession(id, creation, expiration, ticketField, serviceURL);
    }
}

