/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.BuildProxyChainAction;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.protocol.ProtocolError;
import net.shibboleth.idp.cas.protocol.TicketValidationRequest;
import net.shibboleth.idp.cas.protocol.TicketValidationResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BuildProxyChainActionTest
extends AbstractFlowActionTest {
    @Autowired
    private BuildProxyChainAction action;

    @Test
    public void testBuildChainLength2() throws Exception {
        ServiceTicket st = this.createServiceTicket("alpha", true);
        String pgtUrlA = "https://proxya.example.com/";
        ProxyGrantingTicket pgtA = this.createProxyGrantingTicket(st, "https://proxya.example.com/");
        ProxyTicket ptA = this.createProxyTicket(pgtA, "proxiedByA");
        String pgtUrlB = "https://proxyb.example.com/";
        ProxyGrantingTicket pgtB = this.createProxyGrantingTicket(ptA, "https://proxyb.example.com/");
        ProxyTicket ptB = this.createProxyTicket(pgtB, "proxiedByB");
        TicketValidationRequest request = new TicketValidationRequest("proxiedByB", ptB.getId());
        TicketValidationResponse response = new TicketValidationResponse();
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/proxy").addProtocolContext(request, response).addTicketContext((Ticket)ptB).build();
        Assert.assertNull((Object)this.action.execute(context));
        Assert.assertEquals((int)response.getProxies().size(), (int)2);
        Assert.assertEquals((String)((String)response.getProxies().get(0)), (String)"https://proxyb.example.com/");
        Assert.assertEquals((String)((String)response.getProxies().get(1)), (String)"https://proxya.example.com/");
    }

    @Test
    public void testBrokenProxyChain() throws Exception {
        ServiceTicket st = this.createServiceTicket("beta", true);
        String pgtUrlA = "https://proxya.example.com/";
        ProxyGrantingTicket pgtA = this.createProxyGrantingTicket(st, "https://proxya.example.com/");
        ProxyTicket ptA = this.createProxyTicket(pgtA, "proxiedByA");
        String pgtUrlB = "https://proxyb.example.com/";
        ProxyGrantingTicket pgtB = this.createProxyGrantingTicket(ptA, "https://proxyb.example.com/");
        ProxyTicket ptB = this.createProxyTicket(pgtB, "proxiedByB");
        String pgtUrlC = "https://proxyc.example.com/";
        ProxyGrantingTicket pgtC = this.createProxyGrantingTicket(ptB, "https://proxyc.example.com/");
        ProxyTicket ptC = this.createProxyTicket(pgtC, "proxiedByC");
        TicketValidationRequest request = new TicketValidationRequest("proxiedByC", ptC.getId());
        TicketValidationResponse response = new TicketValidationResponse();
        this.ticketService.removeProxyGrantingTicket(pgtB.getId());
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/proxy").addProtocolContext(request, response).addTicketContext((Ticket)ptC).build();
        Event event = this.action.execute(context);
        assert (event != null);
        Assert.assertEquals((String)event.getId(), (String)ProtocolError.BrokenProxyChain.name());
    }
}

