/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import net.shibboleth.idp.cas.config.ProxyConfiguration;
import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.flow.impl.GrantProxyTicketAction;
import net.shibboleth.idp.cas.flow.impl.TestContextBuilder;
import net.shibboleth.idp.cas.protocol.ProxyTicketRequest;
import net.shibboleth.idp.cas.protocol.ProxyTicketResponse;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.profile.config.ProfileConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GrantProxyTicketActionTest
extends AbstractFlowActionTest {
    @Autowired
    private GrantProxyTicketAction action;

    @Test
    public void testGrantProxyTicketSuccess() throws Exception {
        String service = "https://s.example.org/";
        ProxyGrantingTicket pgt = this.createProxyGrantingTicket(this.createServiceTicket("https://s.example.org/", false), "https://s.example.org/proxy");
        RequestContext context = new TestContextBuilder("https://www.apereo.org/cas/protocol/proxy").addProtocolContext(new ProxyTicketRequest(pgt.getId(), "https://s.example.org/"), null).addTicketContext((Ticket)pgt).addRelyingPartyContext("https://s.example.org/", true, (ProfileConfiguration)new ProxyConfiguration()).build();
        Assert.assertNull((Object)this.action.execute(context));
        ProxyTicketResponse response = (ProxyTicketResponse)this.action.getCASResponse(GrantProxyTicketActionTest.getProfileContext(context));
        assert (response != null);
        String pts = response.getPt();
        assert (pts != null);
        ProxyTicket pt = this.ticketService.removeProxyTicket(pts);
        assert (pt != null);
        Assert.assertEquals((String)pt.getId(), (String)response.getPt());
        Assert.assertEquals((String)pt.getService(), (String)"https://s.example.org/");
    }
}

