/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.cas.ticket.TicketContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockExternalContext;
import org.springframework.webflow.test.MockRequestContext;

public class TestContextBuilder {
    @Nonnull
    private ProfileRequestContext profileRequestContext = new ProfileRequestContext();

    public TestContextBuilder(String profileId) {
        this.profileRequestContext.setProfileId(profileId);
    }

    @Nonnull
    public TestContextBuilder addAuthenticationContext(AuthenticationResult result) {
        AuthenticationContext authnCtx = new AuthenticationContext();
        authnCtx.setAuthenticationResult(result);
        this.profileRequestContext.addSubcontext((BaseContext)authnCtx);
        return this;
    }

    @Nonnull
    public TestContextBuilder addSessionContext(IdPSession session) {
        SessionContext sessionContext = new SessionContext();
        sessionContext.setIdPSession(session);
        this.profileRequestContext.addSubcontext((BaseContext)sessionContext);
        return this;
    }

    @Nonnull
    public TestContextBuilder addSubjectContext(String principal) {
        SubjectContext subjectContext = new SubjectContext();
        subjectContext.setPrincipalName(principal);
        this.profileRequestContext.addSubcontext((BaseContext)subjectContext);
        return this;
    }

    @Nonnull
    public TestContextBuilder addProtocolContext(Object request, Object response) {
        ProtocolContext context = new ProtocolContext();
        context.setRequest(request);
        context.setResponse(response);
        this.profileRequestContext.addSubcontext((BaseContext)context);
        return this;
    }

    @Nonnull
    public TestContextBuilder addTicketContext(@Nonnull Ticket ticket) {
        ProtocolContext context = (ProtocolContext)this.profileRequestContext.ensureSubcontext(ProtocolContext.class);
        context.addSubcontext((BaseContext)new TicketContext(ticket));
        return this;
    }

    @Nonnull
    public TestContextBuilder addRelyingPartyContext(String serviceURL, boolean verified, ProfileConfiguration config) {
        RelyingPartyContext rpc = new RelyingPartyContext();
        rpc.setVerified(Boolean.valueOf(verified));
        rpc.setRelyingPartyId(serviceURL);
        rpc.setProfileConfig(config);
        this.profileRequestContext.addSubcontext((BaseContext)rpc);
        return this;
    }

    @Nonnull
    public TestContextBuilder addServiceContext(@Nonnull Service service) {
        ProtocolContext context = (ProtocolContext)this.profileRequestContext.ensureSubcontext(ProtocolContext.class);
        context.addSubcontext((BaseContext)new ServiceContext(service));
        return this;
    }

    @Nonnull
    public RequestContext build() {
        MockRequestContext requestContext = new MockRequestContext();
        MockExternalContext externalContext = new MockExternalContext();
        externalContext.setNativeRequest((Object)new MockHttpServletRequest());
        externalContext.setNativeResponse((Object)new MockHttpServletResponse());
        requestContext.setExternalContext((ExternalContext)externalContext);
        requestContext.getConversationScope().put("opensamlProfileRequestContext", (Object)this.profileRequestContext);
        return requestContext;
    }
}

