/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.proxy.impl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.security.auth.login.FailedLoginException;
import net.shibboleth.idp.cas.flow.impl.AbstractFlowActionTest;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.proxy.impl.HttpClientProxyValidator;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import net.shibboleth.shared.collection.CollectionSupport;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class HttpClientProxyValidatorTest
extends AbstractFlowActionTest {
    @Autowired
    private HttpClientProxyValidator validator;
    @Autowired
    private ApplicationContext context;
    private List<InetAddress> jettyListenAddrs;

    @DataProvider(name="data")
    public Object[][] buildTestData() {
        return new Object[][]{{"https://localhost:8443", "src/test/resources/credentials/localhost.p12", 200, null}, {"https://nobody-1.middleware.vt.edu/", "src/test/resources/credentials/nobody-1.p12", 200, null}, {"https://localhost:8443", "src/test/resources/credentials/localhost.p12", 404, new FailedLoginException()}, {"https://localhost:8443", "src/test/resources/credentials/nobody-2.p12", 200, new CertificateException()}, {"https://localhost:8443", "src/test/resources/credentials/idp-1371.p12", 200, new CertificateException()}};
    }

    @BeforeClass
    public void resolveListenAddresses() throws Exception {
        List localhostAddrs = CollectionSupport.listOf((Object[])SystemDefaultDnsResolver.INSTANCE.resolve("localhost"));
        Set interfaceAddrs = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().map(NetworkInterface::getInterfaceAddresses).flatMap(Collection::stream).map(InterfaceAddress::getAddress).filter(addr -> addr.isLoopbackAddress() || addr.isLinkLocalAddress()).map(InetAddress::getAddress).map(ByteBuffer::wrap).collect(Collectors.toSet());
        this.jettyListenAddrs = localhostAddrs.stream().filter(addr -> interfaceAddrs.contains(ByteBuffer.wrap(addr.getAddress()))).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="data")
    public void testAuthenticate(@Nonnull String serviceURL, String keyStorePath, int status, Exception expected) throws Exception {
        Server server = null;
        try {
            server = this.startServer(keyStorePath, (Handler)new ConfigurableStatusHandler(status));
            this.validator.validate(this.buildProfileRequestContext(serviceURL), new URI("https://localhost:8443/?pgtId=A&pgtIOU=B"));
            if (expected != null) {
                Assert.fail((String)("Proxy authentication should have failed with " + expected));
            }
        }
        catch (Exception e) {
            if (expected == null) {
                throw e;
            }
            Assert.assertTrue((boolean)expected.getClass().isAssignableFrom(e.getClass()));
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    @Nonnull
    private Server startServer(String keyStorePath, Handler handler) {
        final Server server = new Server();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStoreType("PKCS12");
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword("changeit");
        ArrayList connectors = new ArrayList();
        this.jettyListenAddrs.forEach(addr -> {
            ServerConnector connector = new ServerConnector(server, sslContextFactory);
            connector.setHost(addr.getHostAddress());
            connector.setPort(8443);
            connectors.add(connector);
        });
        server.setConnectors(connectors.toArray(new Connector[0]));
        server.setHandler(handler);
        try {
            server.start();
        }
        catch (Exception e) {
            try {
                server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Jetty startup failed", e);
        }
        Thread serverRunner = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    server.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        serverRunner.start();
        return server;
    }

    @Nonnull
    private ProfileRequestContext buildProfileRequestContext(@Nonnull String serviceUrl) {
        ProfileRequestContext prc = new ProfileRequestContext();
        ProtocolContext protoCtx = new ProtocolContext();
        prc.addSubcontext((BaseContext)protoCtx);
        protoCtx.addSubcontext((BaseContext)new ServiceContext(new Service(serviceUrl, "unknown", true, false)));
        return prc;
    }

    private static class ConfigurableStatusHandler
    extends AbstractHandler {
        final int status;

        public ConfigurableStatusHandler(int s) {
            this.status = s;
        }

        public void handle(String target, Request request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
            servletResponse.setContentType("text/plain;charset=utf-8");
            servletResponse.setStatus(this.status);
            request.setHandled(true);
            servletResponse.getWriter().println("OK");
        }
    }
}

