/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket.impl;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.ProxyGrantingTicket;
import net.shibboleth.idp.cas.ticket.ProxyTicket;
import net.shibboleth.idp.cas.ticket.ServiceTicket;
import net.shibboleth.idp.cas.ticket.TicketIdentifierGenerationStrategy;
import net.shibboleth.idp.cas.ticket.TicketState;
import net.shibboleth.idp.cas.ticket.impl.SimpleTicketService;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SimpleTicketServiceTest {
    private static final String TEST_SESSION_ID = "jHXRo42W0ATPEN+X5Zk1cw==";
    private static final String TEST_SERVICE = "https://example.com/widget";
    private static final String TEST_PGTURL = "https://proxy.example.com/";
    private SimpleTicketService ticketService;

    @BeforeClass
    public void setUp() throws Exception {
        MemoryStorageService ss = new MemoryStorageService();
        ss.setId("shibboleth.StorageService");
        ss.initialize();
        this.ticketService = new SimpleTicketService((StorageService)ss);
    }

    @Test
    public void testCreateRemoveServiceTicket() throws Exception {
        ServiceTicket st = this.createServiceTicket(TEST_SESSION_ID);
        Assert.assertNotNull((Object)st);
        TicketState state = st.getTicketState();
        assert (state != null);
        Assert.assertNotNull((Object)state.getSessionId());
        Assert.assertNotNull((Object)state.getPrincipalName());
        ServiceTicket st2 = this.ticketService.removeServiceTicket(st.getId());
        assert (st2 != null);
        Assert.assertEquals((Object)st, (Object)st2);
        Assert.assertEquals((Object)st.getExpirationInstant(), (Object)st2.getExpirationInstant());
        Assert.assertEquals((String)st.getService(), (String)st2.getService());
        Assert.assertEquals((Object)st.getTicketState(), (Object)st2.getTicketState());
        Assert.assertNull((Object)this.ticketService.removeServiceTicket(st.getId()));
    }

    @Test
    public void testCreateRemoveServiceTicketNoSession() throws Exception {
        ServiceTicket st = this.createServiceTicket(null);
        Assert.assertNotNull((Object)st);
        TicketState state = st.getTicketState();
        assert (state != null);
        Assert.assertNull((Object)state.getSessionId());
        Assert.assertNotNull((Object)state.getPrincipalName());
        ServiceTicket st2 = this.ticketService.removeServiceTicket(st.getId());
        Assert.assertEquals((Object)st, (Object)st2);
        assert (st2 != null);
        Assert.assertEquals((Object)st.getExpirationInstant(), (Object)st2.getExpirationInstant());
        Assert.assertEquals((String)st.getService(), (String)st2.getService());
        Assert.assertEquals((Object)st.getTicketState(), (Object)st2.getTicketState());
        Assert.assertNull((Object)this.ticketService.removeServiceTicket(st.getId()));
    }

    @Test
    public void testCreateFetchRemoveProxyGrantingTicket() throws Exception {
        ProxyGrantingTicket pgt = this.createProxyGrantingTicket();
        assert (pgt != null);
        TicketState ts = pgt.getTicketState();
        assert (ts != null);
        Assert.assertNotNull((Object)ts.getSessionId());
        Assert.assertNotNull((Object)ts.getPrincipalName());
        ProxyGrantingTicket pgt2 = this.ticketService.fetchProxyGrantingTicket(pgt.getId());
        assert (pgt2 != null);
        Assert.assertEquals((Object)pgt, (Object)pgt2);
        Assert.assertEquals((Object)pgt.getExpirationInstant(), (Object)pgt2.getExpirationInstant());
        Assert.assertEquals((String)pgt.getService(), (String)pgt2.getService());
        Assert.assertEquals((String)pgt.getProxyCallbackUrl(), (String)pgt2.getProxyCallbackUrl());
        Assert.assertEquals((Object)pgt.getTicketState(), (Object)pgt2.getTicketState());
        Assert.assertEquals((Object)this.ticketService.removeProxyGrantingTicket(pgt.getId()), (Object)pgt);
        Assert.assertNull((Object)this.ticketService.removeProxyGrantingTicket(pgt.getId()));
    }

    @Test
    public void testCreateRemoveProxyTicket() throws Exception {
        ProxyTicket pt = this.ticketService.createProxyTicket(new TicketIdentifierGenerationStrategy("PT", 25).generateIdentifier(), SimpleTicketServiceTest.expiry(), this.createProxyGrantingTicket(), TEST_SERVICE);
        assert (pt != null);
        TicketState ts = pt.getTicketState();
        assert (ts != null);
        Assert.assertNotNull((Object)ts.getSessionId());
        Assert.assertNotNull((Object)ts.getPrincipalName());
        ProxyTicket pt2 = this.ticketService.removeProxyTicket(pt.getId());
        assert (null != pt2);
        Assert.assertEquals((Object)pt, (Object)pt2);
        Assert.assertEquals((Object)pt.getExpirationInstant(), (Object)pt2.getExpirationInstant());
        Assert.assertEquals((String)pt.getService(), (String)pt2.getService());
        Assert.assertEquals((Object)pt.getTicketState(), (Object)pt2.getTicketState());
        Assert.assertNull((Object)this.ticketService.removeProxyTicket(pt.getId()));
    }

    @Nonnull
    private ServiceTicket createServiceTicket(String sessionId) {
        return this.ticketService.createServiceTicket(new TicketIdentifierGenerationStrategy("ST", 25).generateIdentifier(), SimpleTicketServiceTest.expiry(), TEST_SERVICE, new TicketState(sessionId, "bob", SimpleTicketServiceTest.expiry(), "Password"), false);
    }

    @Nonnull
    private ProxyGrantingTicket createProxyGrantingTicket() {
        return this.ticketService.createProxyGrantingTicket(new TicketIdentifierGenerationStrategy("PGT", 50).generateIdentifier(), SimpleTicketServiceTest.expiry(), this.createServiceTicket(TEST_SESSION_ID), TEST_PGTURL);
    }

    @Nonnull
    private static Instant expiry() {
        Instant result = Instant.now().plusSeconds(10L).truncatedTo(ChronoUnit.MILLIS);
        assert (result != null);
        return result;
    }
}

