/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.audit.impl;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class CurrentConsentIdsAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy;

    public CurrentConsentIdsAuditExtractor() {
        this.consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class);
    }

    public CurrentConsentIdsAuditExtractor(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        ConsentContext consentContext = this.consentContextLookupStrategy.apply(input);
        if (consentContext != null) {
            return consentContext.getCurrentConsents().keySet();
        }
        return CollectionSupport.emptyList();
    }
}

