/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.ar.impl.AbstractAttributeReleaseAction;
import net.shibboleth.idp.consent.flow.ar.impl.AttributeReleaseFlowDescriptor;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidatedExtractedConsent
extends AbstractAttributeReleaseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidatedExtractedConsent.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        AttributeReleaseFlowDescriptor flow = this.getAttributeReleaseFlowDescriptor();
        if (flow == null || !flow.isPerAttributeConsentEnabled()) {
            ConsentContext consentContext = this.getConsentContext();
            assert (consentContext != null);
            Map currentConsents = consentContext.getCurrentConsents();
            for (Consent consent : currentConsents.values()) {
                if (consent.isApproved()) continue;
                this.log.warn("{} Consent should have been approved for '{}'", (Object)this.getLogPrefix(), (Object)consent);
                consent.setApproved(Boolean.TRUE.booleanValue());
            }
            this.log.debug("{} Consent context '{}'", (Object)this.getLogPrefix(), (Object)consentContext);
        }
    }
}

