/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractConsentAction
extends AbstractProfileInterceptorAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractConsentAction.class);
    @Nullable
    private ConsentContext consentContext;
    @Nullable
    private ConsentFlowDescriptor consentFlowDescriptor;
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class);

    @Nullable
    public ConsentContext getConsentContext() {
        return this.consentContext;
    }

    @Nullable
    public ConsentFlowDescriptor getConsentFlowDescriptor() {
        return this.consentFlowDescriptor;
    }

    public void setConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        this.consentContext = this.consentContextLookupStrategy.apply(profileRequestContext);
        if (this.consentContext == null) {
            this.log.debug("{} Unable to locate consent context within profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!(interceptorContext.getAttemptedFlow() instanceof ConsentFlowDescriptor)) {
            this.log.debug("{} ProfileInterceptorFlowDescriptor is not a ConsentFlowDescriptor", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.consentFlowDescriptor = (ConsentFlowDescriptor)interceptorContext.getAttemptedFlow();
        return super.doPreExecute(profileRequestContext, interceptorContext);
    }
}

