/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class UpdateCounter
extends AbstractConsentStorageAction {
    @Nonnull
    @NotEmpty
    public static final String COUNTER_KEY = "_counter";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateCounter.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        try {
            String value = Long.toString(System.currentTimeMillis());
            String context = this.getStorageContext();
            String key = this.getStorageKey();
            StorageService service = this.getStorageService();
            assert (context != null && key != null && service != null && value != null);
            StorageRecord storageRecord = service.read(context, key);
            this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, context, key});
            if (storageRecord == null) {
                this.log.debug("{} Creating counter with value '{}'", (Object)this.getLogPrefix(), (Object)value);
                service.create(context, key, value, null);
            } else {
                this.log.debug("{} Updating counter with value '{}'", (Object)this.getLogPrefix(), (Object)value);
                service.update(context, key, value, null);
            }
        }
        catch (IOException e) {
            this.log.debug("{} Unable to update counter", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

