/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;

public class PreferExplicitOrderComparator
implements Comparator<String> {
    @Nonnull
    private final Ordering<String> explicitOrdering;
    @Nonnull
    @Unmodifiable
    private final List<String> explicitOrder;

    public PreferExplicitOrderComparator(@Nullable @NullableElements List<String> order) {
        this.explicitOrder = order == null ? CollectionSupport.emptyList() : (List)((NonnullSupplier)order.stream().map(StringSupport::trimOrNull).filter(e -> e != null).distinct().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
        Ordering ord = Ordering.explicit(this.explicitOrder);
        assert (ord != null);
        this.explicitOrdering = ord;
    }

    @Override
    public int compare(String o1, String o2) {
        boolean containsLeft = this.explicitOrder.contains(o1);
        boolean containsRight = this.explicitOrder.contains(o2);
        if (containsLeft && containsRight) {
            return this.explicitOrdering.compare((Object)o1, (Object)o2);
        }
        if (containsLeft) {
            return -1;
        }
        if (containsRight) {
            return 1;
        }
        return Ordering.natural().compare((Object)o1, (Object)o2);
    }
}

