/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;

public class EncryptionConfigurationLookupFunction
implements Function<ProfileRequestContext, List<EncryptionConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;
    @Nullable
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    public void setRelyingPartyContextLookupStrategy(@Nullable Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = strategy;
    }

    @Nullable
    public List<EncryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
        ProfileConfiguration pc;
        RelyingPartyContext rpc;
        SecurityConfiguration defaultConfig;
        ArrayList configs = Lists.newArrayList();
        configs.add(SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
        if (input != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(input.getProfileId())) != null && defaultConfig.getEncryptionConfiguration() != null) {
            configs.add(defaultConfig.getEncryptionConfiguration());
        }
        if (input != null && this.relyingPartyContextLookupStrategy != null && (rpc = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)input)) != null && (pc = rpc.getProfileConfig()) != null && pc.getSecurityConfiguration() != null) {
            configs.add(pc.getSecurityConfiguration().getEncryptionConfiguration());
        }
        return configs;
    }
}

