/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForProfileSubflow
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckForProfileSubflow.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullAfterInit
    private Direction direction;
    @Nullable
    private RelyingPartyContext rpCtx;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setDirection(@Nonnull Direction executionDirection) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.direction = (Direction)((Object)Constraint.isNotNull((Object)((Object)executionDirection), (String)"Execution direction cannot be null"));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.direction == null) {
            throw new ComponentInitializationException("Execution direction cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.rpCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            return false;
        }
        if (this.rpCtx.getProfileConfig() == null) {
            this.log.debug("{} No profile configuration associated with this profile request", (Object)this.getLogPrefix());
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.direction == Direction.INBOUND && this.rpCtx.getProfileConfig().getInboundSubflowId() != null) {
            this.log.debug("{} Found inbound subflow in profile configuration: {}", (Object)this.getLogPrefix(), (Object)this.rpCtx.getProfileConfig().getInboundSubflowId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.rpCtx.getProfileConfig().getInboundSubflowId());
        } else if (this.direction == Direction.OUTBOUND && this.rpCtx.getProfileConfig().getOutboundSubflowId() != null) {
            this.log.debug("{} Found outbound subflow in profile configuration: {}", (Object)this.getLogPrefix(), (Object)this.rpCtx.getProfileConfig().getOutboundSubflowId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.rpCtx.getProfileConfig().getOutboundSubflowId());
        }
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

