/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadMetadata
extends AbstractProfileAction {
    private final Logger log = LoggerFactory.getLogger(ReloadMetadata.class);
    private ReloadableService<RefreshableMetadataResolver> metadataResolverService;

    public ReloadableService<RefreshableMetadataResolver> getMetadataResolverService() {
        return this.metadataResolverService;
    }

    public void setMetadataResolver(ReloadableService<RefreshableMetadataResolver> service) {
        this.metadataResolverService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(ProfileRequestContext profileRequestContext) {
        ServiceableComponent component = this.metadataResolverService.getServiceableComponent();
        String id = "unpsecified";
        try {
            RefreshableMetadataResolver resolver = (RefreshableMetadataResolver)component.getComponent();
            if (resolver instanceof RefreshableMetadataResolver) {
                id = resolver.getId();
                resolver.refresh();
            } else {
                this.log.error("Injected Service resolved to class {} which does not support refresh", (Object)resolver.getClass().getName());
            }
        }
        catch (ResolverException e) {
            this.log.error("RelyingPartyMetadataProvider '{}': Error during refresh", (Object)id, (Object)e);
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
        super.doExecute(profileRequestContext);
    }
}

