/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectRelyingPartyConfiguration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectRelyingPartyConfiguration.class);
    @NonnullAfterInit
    private RelyingPartyConfigurationResolver rpConfigResolver;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    private RelyingPartyContext relyingPartyCtx;

    public void setRelyingPartyConfigurationResolver(@Nonnull RelyingPartyConfigurationResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.rpConfigResolver = (RelyingPartyConfigurationResolver)Constraint.isNotNull((Object)resolver, (String)"Relying party configuration resolver cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpConfigResolver == null) {
            throw new ComponentInitializationException("RelyingPartyConfigurationResolver cannot be null");
        }
    }

    public boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.relyingPartyCtx = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.relyingPartyCtx == null) {
            this.log.debug("{} No relying party context available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            RelyingPartyConfiguration config = (RelyingPartyConfiguration)this.rpConfigResolver.resolveSingle((Object)profileRequestContext);
            if (config == null) {
                this.log.debug("{} No relying party configuration applies to this request", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
                return;
            }
            this.log.debug("{} Found relying party configuration {} for request", (Object)this.getLogPrefix(), (Object)config.getId());
            this.relyingPartyCtx.setConfiguration(config);
        }
        catch (ResolverException e) {
            this.log.error(this.getLogPrefix() + " Error trying to resolve relying party configuration", (Throwable)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
        }
    }
}

