/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.logic.impl.AnonymousProfilePredicate;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRelyingPartyConfigurationResolver
extends AbstractServiceableComponent<RelyingPartyConfigurationResolver>
implements RelyingPartyConfigurationResolver,
IdentifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultRelyingPartyConfigurationResolver.class);
    @Nonnull
    private List<RelyingPartyConfiguration> rpConfigurations = Collections.emptyList();
    @NonnullAfterInit
    private RelyingPartyConfiguration defaultConfiguration;
    @Nullable
    private RelyingPartyConfiguration anonymousConfiguration;
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> isAnonymousPredicate = new AnonymousProfilePredicate();
    @Nonnull
    @NonnullElements
    private Map<String, SecurityConfiguration> securityConfigurationMap = Collections.emptyMap();
    @Nullable
    private SecurityConfiguration defaultSecurityConfiguration;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<RelyingPartyConfiguration> getRelyingPartyConfigurations() {
        return ImmutableList.copyOf(this.rpConfigurations);
    }

    public void setRelyingPartyConfigurations(@Nonnull @NonnullElements List<RelyingPartyConfiguration> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(configs, (String)"RelyingPartyConfiguration collection cannot be null");
        this.rpConfigurations = Lists.newArrayList((Iterable)Collections2.filter(configs, (Predicate)Predicates.notNull()));
    }

    @NonnullAfterInit
    public RelyingPartyConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setDefaultConfiguration(@Nonnull RelyingPartyConfiguration configuration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultConfiguration = (RelyingPartyConfiguration)Constraint.isNotNull((Object)configuration, (String)"Default RP configuration cannot be null");
    }

    @NonnullAfterInit
    public RelyingPartyConfiguration getAnonymousConfiguration() {
        return this.anonymousConfiguration;
    }

    public void setAnonymousConfiguration(@Nonnull RelyingPartyConfiguration configuration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.anonymousConfiguration = (RelyingPartyConfiguration)Constraint.isNotNull((Object)configuration, (String)"Anonymous RP configuration cannot be null");
    }

    @Nonnull
    public Predicate<ProfileRequestContext> isAnonymousPredicate() {
        return this.isAnonymousPredicate;
    }

    public void setIsAnonymousPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.isAnonymousPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Anonymous profile predicate cannot be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, SecurityConfiguration> getSecurityConfigurationMap() {
        return ImmutableMap.copyOf(this.securityConfigurationMap);
    }

    public void setSecurityConfigurationMap(@Nonnull @NonnullElements Map<String, SecurityConfiguration> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"SecurityConfiguration map cannot be null");
        this.securityConfigurationMap = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<String, SecurityConfiguration> entry : map.entrySet()) {
            String trimmed;
            if (entry.getValue() == null || (trimmed = StringSupport.trimOrNull((String)entry.getKey())) == null) continue;
            this.securityConfigurationMap.put(trimmed, entry.getValue());
        }
    }

    public void setDefaultSecurityConfiguration(@Nullable SecurityConfiguration config) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultSecurityConfiguration = config;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        HashSet configIds = Sets.newHashSetWithExpectedSize((int)this.rpConfigurations.size());
        for (RelyingPartyConfiguration config : this.rpConfigurations) {
            if (configIds.contains(config.getId())) {
                throw new ComponentInitializationException("Multiple replying party configurations with ID " + config.getId() + " detected. Configuration IDs must be unique.");
            }
            configIds.add(config.getId());
        }
    }

    @Nonnull
    @NonnullElements
    public Iterable<RelyingPartyConfiguration> resolve(@Nullable ProfileRequestContext context) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (context == null) {
            return Collections.emptyList();
        }
        this.log.debug("Resolving relying party configurations");
        if (this.isAnonymousPredicate.apply((Object)context) && null != this.getAnonymousConfiguration()) {
            this.log.debug("Profile Request is anonymous: returning configuration {} only", (Object)this.getAnonymousConfiguration().getId());
            return Collections.singleton(this.getAnonymousConfiguration());
        }
        ArrayList matches = Lists.newArrayList();
        for (RelyingPartyConfiguration configuration : this.rpConfigurations) {
            this.log.debug("Checking if relying party configuration {} is applicable", (Object)configuration.getId());
            if (configuration.apply(context)) {
                this.log.debug("Relying party configuration {} is applicable", (Object)configuration.getId());
                matches.add(configuration);
                continue;
            }
            this.log.debug("Relying party configuration {} is not applicable", (Object)configuration.getId());
        }
        if (matches.isEmpty()) {
            this.log.debug("No matching Relying Party Configuration found, returning the default configuration {}", (Object)this.getDefaultConfiguration().getId());
            return Collections.singleton(this.getDefaultConfiguration());
        }
        return matches;
    }

    @Nullable
    public RelyingPartyConfiguration resolveSingle(@Nullable ProfileRequestContext context) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (context == null) {
            return null;
        }
        if (this.isAnonymousPredicate.apply((Object)context) && null != this.getAnonymousConfiguration()) {
            this.log.debug("Profile Request is anonymous: returning configuration {} only", (Object)this.getAnonymousConfiguration().getId());
            return this.getAnonymousConfiguration();
        }
        this.log.debug("Resolving relying party configuration");
        for (RelyingPartyConfiguration configuration : this.rpConfigurations) {
            this.log.debug("Checking if relying party configuration {} is applicable", (Object)configuration.getId());
            if (configuration.apply(context)) {
                this.log.debug("Relying party configuration {} is applicable", (Object)configuration.getId());
                return configuration;
            }
            this.log.debug("Relying party configuration {} is not applicable", (Object)configuration.getId());
        }
        this.log.debug("No relying party configurations are applicable, returning the default configuration {}", (Object)this.getDefaultConfiguration().getId());
        return this.getDefaultConfiguration();
    }

    @Nullable
    public SecurityConfiguration getDefaultSecurityConfiguration(@Nonnull @NotEmpty String profileId) {
        SecurityConfiguration config = this.securityConfigurationMap.get(profileId);
        return config != null ? config : this.defaultSecurityConfiguration;
    }

    public void setId(@Nonnull String componentId) {
        super.setId(componentId);
    }

    @Nonnull
    public RelyingPartyConfigurationResolver getComponent() {
        return this;
    }
}

