/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty.impl;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingRelyingPartyConfigurationResolver
extends AbstractIdentifiableInitializableComponent
implements RelyingPartyConfigurationResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadingRelyingPartyConfigurationResolver.class);
    private final ReloadableService<RelyingPartyConfigurationResolver> service;

    public ReloadingRelyingPartyConfigurationResolver(@Nonnull ReloadableService<RelyingPartyConfigurationResolver> resolverService) {
        this.service = (ReloadableService)Constraint.isNotNull(resolverService, (String)"RelyingParty Service cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public Iterable<RelyingPartyConfiguration> resolve(@Nullable ProfileRequestContext context) throws ResolverException {
        block7: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("RelyingPartyResolver '{}': error looking up Relying Party: Invalid configuration.", (Object)this.getId());
                    break block7;
                }
                RelyingPartyConfigurationResolver resolver = (RelyingPartyConfigurationResolver)component.getComponent();
                HashSet hashSet = Sets.newHashSet((Iterable)resolver.resolve((Object)context));
                return hashSet;
            }
            catch (ResolverException e) {
                this.log.error("RelyingPartyResolver '{}': error in resolution", (Object)this.getId(), (Object)e);
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RelyingPartyConfiguration resolveSingle(@Nullable ProfileRequestContext context) throws ResolverException {
        block7: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("RelyingPartyResolver '{}': error looking up Relying Party: Invalid configuration.", (Object)this.getId());
                    break block7;
                }
                RelyingPartyConfigurationResolver resolver = (RelyingPartyConfigurationResolver)component.getComponent();
                RelyingPartyConfiguration relyingPartyConfiguration = (RelyingPartyConfiguration)resolver.resolveSingle((Object)context);
                return relyingPartyConfiguration;
            }
            catch (ResolverException e) {
                this.log.error("RelyingPartyResolver '{}': error in resolution", (Object)this.getId(), (Object)e);
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityConfiguration getDefaultSecurityConfiguration(String profileId) {
        block5: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("RelyingPartyResolver '{}': error looking up default security config: Invalid configuration.", (Object)this.getId());
                    break block5;
                }
                RelyingPartyConfigurationResolver resolver = (RelyingPartyConfigurationResolver)component.getComponent();
                SecurityConfiguration securityConfiguration = resolver.getDefaultSecurityConfiguration(profileId);
                return securityConfiguration;
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return null;
    }
}

