/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;

public class RecordResponseComplete
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RecordResponseComplete.class);
    @Nullable
    private ExternalContext externalContext;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext == null) {
            this.log.debug("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        RequestContext requestContext = springRequestContext.getRequestContext();
        if (requestContext == null) {
            this.log.debug("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.externalContext = requestContext.getExternalContext();
        if (this.externalContext == null) {
            this.log.debug("{} External context not found in Web Flow request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.externalContext.isResponseComplete()) {
            this.log.debug("{} Record response complete", (Object)this.getLogPrefix());
            this.externalContext.recordResponseComplete();
        }
    }
}

